Use R / Bioconductor for Sequence Analysis
==========================================

Genentech, San Francisco, CA<br />
4 February 2015

Contact: Martin Morgan ([mtmorgan@fhcrc.org](mailto:mtmorgan@fhcrc.org))

This course is directed at intermediate users wanting to make
effective use of _R_ and _[Bioconductor](http://bioconductor.org)_ for
the analysis and comprehension of high-throughput sequence data. The
morning provides overall orientation to the packages and facilities
available in _Bioconductor_, including and in-depth look at the
central _GenomicRanges_ infrastructure. The afternoon provides
approaches to common challenges -- working with large data, placing
statistical results in biological context, and effectively and
reliably communicating results with other team members.  The course
combines lectures with extensive hands-on practicals; participants are
required to bring a laptop with wireless internet access and a modern
version of the Chrome or Safari web browser.

Schedule (tentative)
--------------------

Day 1: Use _R_ / _Bioconductor_

- 9:00 - 10:00 Introduction to _Bioconductor_: package and class
  infrastructure in the high-throughput sequencing landscape
- 10:00 - 11:45 GenomicRanges design and use for data and annotation
- 11:45 - 12:30 A high-level tour of new and relevant packages
- 1:30 - 2:30 Working with large data and collections of genomic files
- 2:30 - 3:30 Package, web, and cloud-based annotation resources,
  including use of data base and web service resources
- 3:45 - 4:45 Genome-specific visualization and reports, including
  interactivity
- 4:45 - 5:00 Summary
