% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadXcmsData.R
\name{loadXcmsData}
\alias{loadXcmsData}
\alias{xdata}
\alias{xmse}
\alias{faahko_sub}
\alias{faahko_sub2}
\title{LC-MS preprocessing result test data sets}
\usage{
loadXcmsData(x = c("xmse", "xdata", "faahko_sub", "faahko_sub2"))
}
\arguments{
\item{x}{For `loadXcmsData`: `character(1)` with the name of the data file
(object) to load.}
}
\description{
Data sets with `xcms` preprocessing results are provided within the `xcms`
package and can be loaded with the `loadXcmsData` function. The available
Test data sets are:

- `xdata`: an [XCMSnExp()] object with the results from a `xcms`-based
  pre-processing of an LC-MS untargeted metabolomics data set. The raw data
  files are provided in the `faahKO` R package.

- `xmse`: an [XcmsExperiment()] object with the results from an `xcms`-based
  pre-processing of an LC-MS untargeted metabolomics data set (same original
  data set and pre-processing settings as for the `xdata` data set).
  The pre-processing of this data set is described in detail in the *xcms*
  vignette of the `xcms` package.

- `faahko_sub`: an [XCMSnExp()] object with identified
  chromatographic peaks in 3 samples from the data files in the `faahKO`
  R package.

- `faahko_sub2`: an [XcmsExperiment()] object with identified
  chromatographic peaks in 3 samples from the data files in the `faahKO`
  R package.

Data sets can also be loaded using `data`, which would however require to
update objects to point to the location of the raw data files. The
`loadXcmsData` loads the data and ensures that all paths are updated
accordingly.
}
\examples{

library(xcms)
xdata <- loadXcmsData()
}
