% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-xcmsRaw.R
\name{findPeaks.MSW,xcmsRaw-method}
\alias{findPeaks.MSW,xcmsRaw-method}
\alias{findPeaks.MSW}
\title{Peak detection for single-spectrum non-chromatography MS data}
\usage{
\S4method{findPeaks.MSW}{xcmsRaw}(object, snthresh = 3, verbose.columns = FALSE, ...)
}
\arguments{
\item{object}{The \code{\linkS4class{xcmsRaw}} object on which peak
detection should be performed.}

\item{snthresh}{\code{numeric(1)} defining the signal to noise ratio cutoff.}

\item{verbose.columns}{Logical whether additional peak meta data columns
should be returned.}

\item{...}{Additional parameters to be passed to the
\code{\link{peakDetectionCWT}} and
\code{\link{identifyMajorPeaks}} functions from the
\code{MassSpecWavelet} package.}
}
\value{
A matrix, each row representing an intentified peak, with columns:
    \describe{
    \item{mz}{m/z value of the peak at the centroid position.}
    \item{mzmin}{Minimum m/z of the peak.}
    \item{mzmax}{Maximum m/z of the peak.}
    \item{rt}{Always \code{-1}.}
    \item{rtmin}{Always \code{-1}.}
    \item{rtmax}{Always \code{-1}.}
    \item{into}{Integrated (original) intensity of the peak.}
    \item{maxo}{Maximum intensity of the peak.}
    \item{intf}{Always \code{NA}.}
    \item{maxf}{Maximum MSW-filter response of the peak.}
    \item{sn}{Signal to noise ratio.}
    }
}
\description{
This method performs peak detection in mass spectrometry
    direct injection spectrum using a wavelet based algorithm.
}
\details{
This is a wrapper around the peak picker in Bioconductor's
    \code{MassSpecWavelet} package calling
    \code{\link{peakDetectionCWT}} and
    \code{\link{tuneInPeakInfo}} functions.
}
\seealso{
\code{\link{MSW}} for the new user interface,
    \code{\link{do_findPeaks_MSW}} for the downstream analysis
    function or \code{\link{peakDetectionCWT}} from the
    \code{MassSpecWavelet} for details on the algorithm and additionally
    supported parameters.
}
\author{
Joachim Kutzera, Steffen Neumann, Johannes Rainer
}
