% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R
\name{findChromPeaks}
\alias{findChromPeaks}
\alias{findChromPeaks,MsExperiment,Param-method}
\alias{findChromPeaks,XcmsExperiment,Param-method}
\title{Chromatographic Peak Detection}
\usage{
findChromPeaks(object, param, ...)

\S4method{findChromPeaks}{MsExperiment,Param}(
  object,
  param,
  msLevel = 1L,
  chunkSize = 2L,
  ...,
  BPPARAM = bpparam()
)

\S4method{findChromPeaks}{XcmsExperiment,Param}(
  object,
  param,
  msLevel = 1L,
  chunkSize = 2L,
  add = FALSE,
  ...,
  BPPARAM = bpparam()
)
}
\arguments{
\item{object}{The data object on which to perform the peak detection. Can be
an \code{\link[MSnbase:OnDiskMSnExp-class]{MSnbase::OnDiskMSnExp()}}, \code{\link[=XCMSnExp]{XCMSnExp()}}, \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}}
or \code{\link[MsExperiment:MsExperiment]{MsExperiment::MsExperiment()}} object.}

\item{param}{The parameter object selecting and configuring the algorithm.}

\item{...}{Optional parameters.}

\item{msLevel}{\code{integer(1)} defining the MS level on which the
chromatographic peak detection should be performed.}

\item{chunkSize}{\code{integer(1)} for \code{object} being an \code{MsExperiment} or
\code{\link[=XcmsExperiment]{XcmsExperiment()}}: defines the number of files (samples) for which the
full peaks data (m/z and intensity values) should be loaded into memory
at the same time. Peak detection is then performed in parallel (per
sample) on this subset of loaded data. This setting thus allows to
balance between memory demand and speed (due to parallel processing) of
the peak detection. Because parallel processing can only performed on
the subset of data loaded currently into memory (in each iteration), the
value for \code{chunkSize} should be match the defined  parallel setting
setup. Using a parallel processing setup using 4 CPUs (separate
processes) but using \verb{chunkSize = }1\verb{will not perform any parallel processing, as only the data from one sample is loaded in memory at a time. On the other hand, setting}chunkSize\verb{to the total number of samples in an experiment will load the full MS data into memory and will thus in most settings cause an out-of-memory error. By setting}chunkSize = -1\verb{the peak detection will be performed separately, and in parallel, for each sample. This will however not work for all}Spectra` \emph{backends} (see eventually \code{\link[Spectra:Spectra]{Spectra::Spectra()}} for
details).}

\item{BPPARAM}{Parallel processing setup. Uses by default the system-wide
default setup. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for more details.}

\item{add}{\code{logical(1)} (if \code{object} contains already chromatographic peaks,
i.e. is either an \code{XCMSnExp} or \code{XcmsExperiment}) whether chromatographic
peak detection results should be \strong{added} to existing results. By
default (\code{add = FALSE}) any additional \code{findChromPeaks} call on a result
object will remove previous results.}
}
\description{
The \code{findChromPeaks} method performs chromatographic peak detection on
LC/GC-MS data. The peak detection algorithm can be selected, and configured,
using the \code{param} argument.

Supported \code{param} objects are:
\itemize{
\item \code{\link[=CentWaveParam]{CentWaveParam()}}: chromatographic peak detection using the \emph{centWave}
algorithm.
\item \code{\link[=CentWavePredIsoParam]{CentWavePredIsoParam()}}: \emph{centWave} with predicted isotopes. Peak
detection uses a two-step centWave-based approach considering also feature
isotopes.
\item \code{\link[=MatchedFilterParam]{MatchedFilterParam()}}: peak detection using the \emph{matched filter}
algorithm.
\item \code{\link[=MassifquantParam]{MassifquantParam()}}: peak detection using the Kalman filter-based
\emph{massifquant} method.
\item \code{\link[=MSWParam]{MSWParam()}}: single-spectrum non-chromatography MS data peak detection.
}

For specific examples see the help pages of the individual parameter classes
listed above.
}
\seealso{
\code{\link[=plotChromPeaks]{plotChromPeaks()}} to plot identified chromatographic peaks for one file.

\code{\link[=refineChromPeaks]{refineChromPeaks()}} for methods to \emph{refine} or clean identified
chromatographic peaks.

\code{\link[=manualChromPeaks]{manualChromPeaks()}} to manually add/define chromatographic peaks.

Other peak detection methods: 
\code{\link{findChromPeaks-centWave}},
\code{\link{findChromPeaks-centWaveWithPredIsoROIs}},
\code{\link{findChromPeaks-massifquant}},
\code{\link{findChromPeaks-matchedFilter}},
\code{\link{findPeaks-MSW}}
}
\author{
Johannes Rainer
}
\concept{peak detection methods}
