% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R, R/functions-Params.R,
%   R/methods-OnDiskMSnExp.R, R/methods-Params.R
\docType{class}
\name{findChromPeaks-matchedFilter}
\alias{findChromPeaks-matchedFilter}
\alias{matchedFilter}
\alias{MatchedFilterParam-class}
\alias{MatchedFilterParam}
\alias{findChromPeaks,OnDiskMSnExp,MatchedFilterParam-method}
\alias{binSize,MatchedFilterParam-method}
\alias{binSize}
\alias{binSize<-,MatchedFilterParam-method}
\alias{binSize<-}
\alias{impute,MatchedFilterParam-method}
\alias{impute<-,MatchedFilterParam-method}
\alias{impute<-}
\alias{baseValue,MatchedFilterParam-method}
\alias{baseValue}
\alias{baseValue<-,MatchedFilterParam-method}
\alias{baseValue<-}
\alias{distance,MatchedFilterParam-method}
\alias{distance}
\alias{distance<-,MatchedFilterParam-method}
\alias{distance<-}
\alias{fwhm,MatchedFilterParam-method}
\alias{fwhm}
\alias{fwhm<-,MatchedFilterParam-method}
\alias{fwhm<-}
\alias{sigma,MatchedFilterParam-method}
\alias{sigma}
\alias{sigma<-,MatchedFilterParam-method}
\alias{sigma<-}
\alias{max,MatchedFilterParam-method}
\alias{max<-,MatchedFilterParam-method}
\alias{max<-}
\alias{snthresh,MatchedFilterParam-method}
\alias{snthresh<-,MatchedFilterParam-method}
\alias{steps,MatchedFilterParam-method}
\alias{steps}
\alias{steps<-,MatchedFilterParam-method}
\alias{steps<-}
\alias{mzdiff,MatchedFilterParam-method}
\alias{mzdiff<-,MatchedFilterParam-method}
\alias{index,MatchedFilterParam-method}
\alias{index}
\alias{index<-,MatchedFilterParam-method}
\alias{index<-}
\title{Peak detection in the chromatographic time domain}
\usage{
MatchedFilterParam(
  binSize = 0.1,
  impute = "none",
  baseValue = numeric(),
  distance = numeric(),
  fwhm = 30,
  sigma = fwhm/2.3548,
  max = 5,
  snthresh = 10,
  steps = 2,
  mzdiff = 0.8 - binSize * steps,
  index = FALSE
)

\S4method{findChromPeaks}{OnDiskMSnExp,MatchedFilterParam}(
  object,
  param,
  BPPARAM = bpparam(),
  return.type = "XCMSnExp",
  msLevel = 1L,
  ...
)

\S4method{binSize}{MatchedFilterParam}(object)

\S4method{binSize}{MatchedFilterParam}(object) <- value

\S4method{impute}{MatchedFilterParam}(object)

\S4method{impute}{MatchedFilterParam}(object) <- value

\S4method{baseValue}{MatchedFilterParam}(object)

\S4method{baseValue}{MatchedFilterParam}(object) <- value

\S4method{distance}{MatchedFilterParam}(object)

\S4method{distance}{MatchedFilterParam}(object) <- value

\S4method{fwhm}{MatchedFilterParam}(object)

\S4method{fwhm}{MatchedFilterParam}(object) <- value

\S4method{sigma}{MatchedFilterParam}(object)

\S4method{sigma}{MatchedFilterParam}(object) <- value

\S4method{max}{MatchedFilterParam}(x)

\S4method{max}{MatchedFilterParam}(object) <- value

\S4method{snthresh}{MatchedFilterParam}(object)

\S4method{snthresh}{MatchedFilterParam}(object) <- value

\S4method{steps}{MatchedFilterParam}(object)

\S4method{steps}{MatchedFilterParam}(object) <- value

\S4method{mzdiff}{MatchedFilterParam}(object)

\S4method{mzdiff}{MatchedFilterParam}(object) <- value

\S4method{index}{MatchedFilterParam}(object)

\S4method{index}{MatchedFilterParam}(object) <- value
}
\arguments{
\item{binSize}{\code{numeric(1)} specifying the width of the
bins/slices in m/z dimension.}

\item{impute}{Character string specifying the method to be used for missing
value imputation. Allowed values are \code{"none"} (no linear
interpolation), \code{"lin"} (linear interpolation), \code{"linbase"}
(linear interpolation within a certain bin-neighborhood) and
\code{"intlin"}. See \code{\link{imputeLinInterpol}} for more details.}

\item{baseValue}{The base value to which empty elements should be set. This
is only considered for \code{method = "linbase"} and corresponds to the
\code{profBinLinBase}'s \code{baselevel} argument.}

\item{distance}{For \code{method = "linbase"}: number of non-empty
neighboring element of an empty element that should be considered for
linear interpolation. See details section for more information.}

\item{fwhm}{\code{numeric(1)} specifying the full width at half maximum
of matched filtration gaussian model peak. Only used to calculate the
actual sigma, see below.}

\item{sigma}{\code{numeric(1)} specifying the standard deviation (width)
of the matched filtration model peak.}

\item{max}{\code{numeric(1)} representing the maximum number of peaks
that are expected/will be identified per slice.}

\item{snthresh}{\code{numeric(1)} defining the signal to noise cutoff
to be used in the chromatographic peak detection step.}

\item{steps}{\code{numeric(1)} defining the number of bins to be
merged before filtration (i.e. the number of neighboring bins that will
be joined to the slice in which filtration and peak detection will be
performed).}

\item{mzdiff}{\code{numeric(1)} defining the minimum difference
in m/z for peaks with overlapping retention times}

\item{index}{\code{logical(1)} specifying whether indicies should be
returned instead of values for m/z and retention times.}

\item{object}{For \code{findChromPeaks}: an
    \code{\link{OnDiskMSnExp}} object containing the MS- and all
    other experiment-relevant data.

    For all other methods: a parameter object.}

\item{param}{An \code{MatchedFilterParam} object containing all settings for
the matchedFilter algorithm.}

\item{BPPARAM}{A parameter class specifying if and how parallel processing
should be performed. It defaults to \code{\link{bpparam}}.
See documentation of the \code{BiocParallel} for more details. If
parallel processing is enabled, peak detection is performed in parallel
on several of the input samples.}

\item{return.type}{Character specifying what type of object the method should
return. Can be either \code{"XCMSnExp"} (default), \code{"list"} or
\code{"xcmsSet"}.}

\item{msLevel}{\code{integer(1)} defining the MS level on which the peak
detection should be performed. Defaults to \code{msLevel = 1}.}

\item{...}{ignored.}

\item{value}{The value for the slot.}

\item{x}{For \code{max}: a \code{MatchedFilterParam} object.}
}
\value{
The \code{MatchedFilterParam} function returns a
    \code{MatchedFilterParam} class instance with all of the settings
    specified for chromatographic detection by the \emph{matchedFilter}
    method.

For \code{findChromPeaks}: if \code{return.type = "XCMSnExp"} an
    \code{\link{XCMSnExp}} object with the results of the peak detection.
    If \code{return.type = "list"} a list of length equal to the number of
    samples with matrices specifying the identified peaks.
    If \code{return.type = "xcmsSet"} an \code{\linkS4class{xcmsSet}} object
    with the results of the peak detection.
}
\description{
The \emph{matchedFilter} algorithm identifies peaks in the
    chromatographic time domain as described in [Smith 2006]. The intensity
    values are binned by cutting The LC/MS data into slices (bins) of a mass
    unit (\code{binSize} m/z) wide. Within each bin the maximal intensity is
    selected. The chromatographic peak detection is then performed in each
    bin by extending it based on the \code{steps} parameter to generate
    slices comprising bins \code{current_bin - steps +1} to
    \code{current_bin + steps - 1}. Each of these slices is then filtered
    with matched filtration using a second-derative Gaussian as the model
    peak shape. After filtration peaks are detected using a signal-to-ratio
    cut-off. For more details and illustrations see [Smith 2006].

The \code{MatchedFilterParam} class allows to specify all
    settings for a chromatographic peak detection using the matchedFilter
    method. Instances should be created with the \code{MatchedFilterParam}
    constructor.

The \code{findChromPeaks,OnDiskMSnExp,MatchedFilterParam}
    method performs peak detection using the \emph{matchedFilter} algorithm
    on all samples from an \code{\link{OnDiskMSnExp}} object.
    \code{\link{OnDiskMSnExp}} objects encapsule all experiment
    specific data and load the spectra data (mz and intensity values) on the
    fly from the original files applying also all eventual data
    manipulations.

\code{binSize},\code{binSize<-}: getter and setter for the
    \code{binSize} slot of the object.

\code{impute},\code{impute<-}: getter and setter for the
    \code{impute} slot of the object.

\code{baseValue},\code{baseValue<-}: getter and setter for the
    \code{baseValue} slot of the object.

\code{distance},\code{distance<-}: getter and setter for the
    \code{distance} slot of the object.

\code{fwhm},\code{fwhm<-}: getter and setter for the
    \code{fwhm} slot of the object.

\code{sigma},\code{sigma<-}: getter and setter for the
    \code{sigma} slot of the object.

\code{max},\code{max<-}: getter and setter for the
     \code{max} slot of the object.

\code{snthresh},\code{snthresh<-}: getter and setter for the
    \code{snthresh} slot of the object.

\code{steps},\code{steps<-}: getter and setter for the
    \code{steps} slot of the object.

\code{mzdiff},\code{mzdiff<-}: getter and setter for the
     \code{mzdiff} slot of the object.

\code{index},\code{index<-}: getter and setter for the
    \code{index} slot of the object.
}
\details{
The intensities are binned by the provided m/z values within each
    spectrum (scan). Binning is performed such that the bins are centered
    around the m/z values (i.e. the first bin includes all m/z values between
    \code{min(mz) - bin_size/2} and \code{min(mz) + bin_size/2}).

    For more details on binning and missing value imputation see
    \code{\link{binYonX}} and \code{\link{imputeLinInterpol}} methods.

Parallel processing (one process per sample) is supported and can
    be configured either by the \code{BPPARAM} parameter or by globally
    defining the parallel processing mode using the
    \code{\link{register}} method from the \code{BiocParallel}
    package.
}
\section{Slots}{

\describe{
\item{\code{binSize,impute,baseValue,distance,fwhm,sigma,max,snthresh,steps,mzdiff,index}}{See corresponding parameter above. Slots values should exclusively
be accessed \emph{via} the corresponding getter and setter methods listed
above.}
}}

\note{
These methods and classes are part of the updated and modernized
    \code{xcms} user interface which will eventually replace the
    \code{\link{findPeaks}} methods. It supports chromatographic peak
    detection on
    \code{\link{OnDiskMSnExp}} objects (defined in the
    \code{MSnbase} package). All of the settings to the matchedFilter
    algorithm can be passed with a \code{MatchedFilterParam} object.
}
\examples{

## Create a MatchedFilterParam object. Note that we use a unnecessarily large
## binSize parameter to reduce the run-time of the example.
mfp <- MatchedFilterParam(binSize = 5)
## Change snthresh parameter
snthresh(mfp) <- 15
mfp

## Perform the peak detection using matchecFilter on the files from the
## faahKO package. Files are read using the readMSData from the MSnbase
## package
library(faahKO)
library(MSnbase)
fls <- dir(system.file("cdf/KO", package = "faahKO"), recursive = TRUE,
           full.names = TRUE)
raw_data <- readMSData(fls[1], mode = "onDisk")
## Perform the chromatographic peak detection using the settings defined
## above. Note that we are also disabling parallel processing in this
## example by registering a "SerialParam"
res <- findChromPeaks(raw_data, param = mfp)
head(chromPeaks(res))
}
\references{
Colin A. Smith, Elizabeth J. Want, Grace O'Maille, Ruben Abagyan and
Gary Siuzdak. "XCMS: Processing Mass Spectrometry Data for Metabolite
Profiling Using Nonlinear Peak Alignment, Matching, and Identification"
\emph{Anal. Chem.} 2006, 78:779-787.
}
\seealso{
The \code{\link{do_findChromPeaks_matchedFilter}} core API function
and \code{\link{findPeaks.matchedFilter}} for the old user interface.

\code{\link{peaksWithMatchedFilter}} for functions to perform matchedFilter
peak detection in purely chromatographic data.

\code{\link{XCMSnExp}} for the object containing the results of
    the chromatographic peak detection.

Other peak detection methods: 
\code{\link{findChromPeaks}()},
\code{\link{findChromPeaks-centWave}},
\code{\link{findChromPeaks-centWaveWithPredIsoROIs}},
\code{\link{findChromPeaks-massifquant}},
\code{\link{findPeaks-MSW}}
}
\author{
Colin A Smith, Johannes Rainer
}
\concept{peak detection methods}
