% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R, R/functions-Params.R,
%   R/methods-OnDiskMSnExp.R, R/methods-Params.R
\docType{class}
\name{findChromPeaks-centWaveWithPredIsoROIs}
\alias{findChromPeaks-centWaveWithPredIsoROIs}
\alias{centWaveWithPredIsoROIs}
\alias{CentWavePredIsoParam-class}
\alias{CentWavePredIsoParam}
\alias{findChromPeaks,OnDiskMSnExp,CentWavePredIsoParam-method}
\alias{snthreshIsoROIs,CentWavePredIsoParam-method}
\alias{snthreshIsoROIs}
\alias{snthreshIsoROIs<-,CentWavePredIsoParam-method}
\alias{snthreshIsoROIs<-}
\alias{maxCharge,CentWavePredIsoParam-method}
\alias{maxCharge}
\alias{maxCharge<-,CentWavePredIsoParam-method}
\alias{maxCharge<-}
\alias{maxIso,CentWavePredIsoParam-method}
\alias{maxIso}
\alias{maxIso<-,CentWavePredIsoParam-method}
\alias{maxIso<-}
\alias{mzIntervalExtension,CentWavePredIsoParam-method}
\alias{mzIntervalExtension}
\alias{mzIntervalExtension<-,CentWavePredIsoParam-method}
\alias{mzIntervalExtension<-}
\alias{polarity,CentWavePredIsoParam-method}
\alias{polarity<-,CentWavePredIsoParam-method}
\alias{polarity<-}
\title{Two-step centWave peak detection considering also isotopes}
\usage{
CentWavePredIsoParam(
  ppm = 25,
  peakwidth = c(20, 50),
  snthresh = 10,
  prefilter = c(3, 100),
  mzCenterFun = "wMean",
  integrate = 1L,
  mzdiff = -0.001,
  fitgauss = FALSE,
  noise = 0,
  verboseColumns = FALSE,
  roiList = list(),
  firstBaselineCheck = TRUE,
  roiScales = numeric(),
  extendLengthMSW = FALSE,
  verboseBetaColumns = FALSE,
  snthreshIsoROIs = 6.25,
  maxCharge = 3,
  maxIso = 5,
  mzIntervalExtension = TRUE,
  polarity = "unknown"
)

\S4method{findChromPeaks}{OnDiskMSnExp,CentWavePredIsoParam}(
  object,
  param,
  BPPARAM = bpparam(),
  return.type = "XCMSnExp",
  msLevel = 1L,
  ...
)

\S4method{snthreshIsoROIs}{CentWavePredIsoParam}(object)

\S4method{snthreshIsoROIs}{CentWavePredIsoParam}(object) <- value

\S4method{maxCharge}{CentWavePredIsoParam}(object)

\S4method{maxCharge}{CentWavePredIsoParam}(object) <- value

\S4method{maxIso}{CentWavePredIsoParam}(object)

\S4method{maxIso}{CentWavePredIsoParam}(object) <- value

\S4method{mzIntervalExtension}{CentWavePredIsoParam}(object)

\S4method{mzIntervalExtension}{CentWavePredIsoParam}(object) <- value

\S4method{polarity}{CentWavePredIsoParam}(object)

\S4method{polarity}{CentWavePredIsoParam}(object) <- value
}
\arguments{
\item{ppm}{\code{numeric(1)} defining the maximal tolerated m/z deviation in
consecutive scans in parts per million (ppm) for the initial ROI
definition.}

\item{peakwidth}{\code{numeric(2)} with the expected approximate
peak width in chromatographic space. Given as a range (min, max)
in seconds.}

\item{snthresh}{\code{numeric(1)} defining the signal to noise ratio cutoff.}

\item{prefilter}{\code{numeric(2)}: \code{c(k, I)} specifying the prefilter
step for the first analysis step (ROI detection). Mass traces are only
retained if they contain at least \code{k} peaks with intensity
\code{>= I}.}

\item{mzCenterFun}{Name of the function to calculate the m/z center of the
chromatographic peak. Allowed are: \code{"wMean"}: intensity weighted
mean of the peak's m/z values, \code{"mean"}: mean of the peak's m/z
values, \code{"apex"}: use the m/z value at the peak apex,
\code{"wMeanApex3"}: intensity weighted mean of the m/z value at the
peak apex and the m/z values left and right of it and \code{"meanApex3"}:
mean of the m/z value of the peak apex and the m/z values left and right
of it.}

\item{integrate}{Integration method. For \code{integrate = 1} peak limits
are found through descent on the mexican hat filtered data, for
\code{integrate = 2} the descent is done on the real data. The latter
method is more accurate but prone to noise, while the former is more
robust, but less exact.}

\item{mzdiff}{\code{numeric(1)} representing the minimum difference in m/z
dimension required for peaks with overlapping retention times; can be
negative to allow overlap. During peak post-processing, peaks
defined to be overlapping are reduced to the one peak with the largest
signal.}

\item{fitgauss}{\code{logical(1)} whether or not a Gaussian should be fitted
to each peak. This affects mostly the retention time position of the
peak.}

\item{noise}{\code{numeric(1)} allowing to set a minimum intensity required
for centroids to be considered in the first analysis step (centroids with
intensity \code{< noise} are omitted from ROI detection).}

\item{verboseColumns}{\code{logical(1)} whether additional peak meta data
columns should be returned.}

\item{roiList}{An optional list of regions-of-interest (ROI) representing
detected mass traces. If ROIs are submitted the first analysis step is
omitted and chromatographic peak detection is performed on the submitted
ROIs. Each ROI is expected to have the following elements specified:
\code{scmin} (start scan index), \code{scmax} (end scan index),
\code{mzmin} (minimum m/z), \code{mzmax} (maximum m/z), \code{length}
(number of scans), \code{intensity} (summed intensity). Each ROI should
be represented by a \code{list} of elements or a single row
\code{data.frame}.}

\item{firstBaselineCheck}{\code{logical(1)}. If \code{TRUE} continuous
data within regions of interest is checked to be above the first baseline.
In detail, a first rough estimate of the noise is calculated and peak
detection is performed only in regions in which multiple sequential
signals are higher than this first estimated baseline/noise level.}

\item{roiScales}{Optional numeric vector with length equal to \code{roiList}
defining the scale for each region of interest in \code{roiList} that
should be used for the centWave-wavelets.}

\item{extendLengthMSW}{Option to force centWave to use all scales when
running centWave rather than truncating with the EIC length. Uses the "open"
method to extend the EIC to a integer base-2 length prior to being passed to
\code{convolve} rather than the default "reflect" method. See
https://github.com/sneumann/xcms/issues/445 for more information.}

\item{verboseBetaColumns}{Option to calculate two additional metrics of peak
quality via comparison to an idealized bell curve. Adds \code{beta_cor} and
\code{beta_snr} to the \code{chromPeaks} output, corresponding to a Pearson
correlation coefficient to a bell curve with several degrees of skew as well
as an estimate of signal-to-noise using the residuals from the best-fitting
bell curve. See https://github.com/sneumann/xcms/pull/685 and
https://doi.org/10.1186/s12859-023-05533-4 for more information.}

\item{snthreshIsoROIs}{\code{numeric(1)} defining the signal to noise ratio
cutoff to be used in the second centWave run to identify peaks for
predicted isotope ROIs.}

\item{maxCharge}{\code{integer(1)} defining the maximal isotope charge.
Isotopes will be defined for charges \code{1:maxCharge}.}

\item{maxIso}{\code{integer(1)} defining the number of isotope peaks that
should be predicted for each peak identified in the first centWave run.}

\item{mzIntervalExtension}{\code{logical(1)} whether the mz range for the
predicted isotope ROIs should be extended to increase detection of low
intensity peaks.}

\item{polarity}{\code{character(1)} specifying the polarity of the data.
Currently not used, but has to be \code{"positive"}, \code{"negative"} or
\code{"unknown"} if provided.}

\item{object}{For \code{findChromPeaks}: an
    \code{\link{OnDiskMSnExp}}  object containing the MS- and all
    other experiment-relevant data.

    For all other methods: a parameter object.}

\item{param}{An \code{CentWavePredIsoParam} object with the settings for the
chromatographic peak detection algorithm.}

\item{BPPARAM}{A parameter class specifying if and how parallel processing
should be performed. It defaults to \code{\link{bpparam}}.
See documentation of the \code{BiocParallel} for more details. If
parallel processing is enabled, peak detection is performed in parallel
on several of the input samples.}

\item{return.type}{Character specifying what type of object the method should
return. Can be either \code{"XCMSnExp"} (default), \code{"list"} or
\code{"xcmsSet"}.}

\item{msLevel}{\code{integer(1)} defining the MS level on which the peak
detection should be performed. Defaults to \code{msLevel = 1}.}

\item{...}{ignored.}

\item{value}{The value for the slot.}
}
\value{
The \code{CentWavePredIsoParam} function returns a
    \code{CentWavePredIsoParam} class instance with all of the settings
    specified for the two-step centWave-based peak detection considering also
    isotopes.

For \code{findChromPeaks}: if \code{return.type = "XCMSnExp"} an
    \code{\link{XCMSnExp}} object with the results of the peak detection.
    If \code{return.type = "list"} a list of length equal to the number of
    samples with matrices specifying the identified peaks.
    If \code{return.type = "xcmsSet"} an \code{\linkS4class{xcmsSet}} object
    with the results of the peak detection.
}
\description{
This method performs a two-step centWave-based chromatographic
    peak detection: in a first centWave run peaks are identified for which
    then the location of their potential isotopes in the mz-retention time is
    predicted. A second centWave run is then performed on these
    \emph{regions of interest} (ROIs). The final list of chromatographic
    peaks comprises all non-overlapping peaks from both centWave runs.

The \code{CentWavePredIsoParam} class allows to specify all
    settings for the two-step centWave-based peak detection considering also
    predicted isotopes of peaks identified in the first centWave run.
    Instances should be created with the \code{CentWavePredIsoParam}
    constructor. See also the documentation of the
    \code{\link{CentWaveParam}} for all methods and arguments this class
    inherits.

The \code{findChromPeaks,OnDiskMSnExp,CentWavePredIsoParam}
    method performs a two-step centWave-based chromatographic peak detection
    on all samples from an \code{\link{OnDiskMSnExp}} object.
    \code{\link{OnDiskMSnExp}} objects encapsule all experiment
    specific data and load the spectra data (mz and intensity values) on the
    fly from the original files applying also all eventual data
    manipulations.

\code{snthreshIsoROIs},\code{snthreshIsoROIs<-}: getter and
    setter for the \code{snthreshIsoROIs} slot of the object.

\code{maxCharge},\code{maxCharge<-}: getter and
    setter for the \code{maxCharge} slot of the object.

\code{maxIso},\code{maxIso<-}: getter and
    setter for the \code{maxIso} slot of the object.

\code{mzIntervalExtension},\code{mzIntervalExtension<-}: getter
    and setter for the \code{mzIntervalExtension} slot of the object.

\code{polarity},\code{polarity<-}: getter and
    setter for the \code{polarity} slot of the object.
}
\details{
See \code{\link{centWave}} for details on the centWave method.

Parallel processing (one process per sample) is supported and can
    be configured either by the \code{BPPARAM} parameter or by globally
    defining the parallel processing mode using the
    \code{\link{register}} method from the \code{BiocParallel}
    package.
}
\section{Slots}{

\describe{
\item{\code{ppm,peakwidth,snthresh,prefilter,mzCenterFun,integrate,mzdiff,fitgauss,noise,verboseColumns,roiList,firstBaselineCheck,roiScales,extendLengthMSW,verboseBetaColumns,snthreshIsoROIs,maxCharge,maxIso,mzIntervalExtension,polarity}}{See corresponding parameter above.}
}}

\note{
These methods and classes are part of the updated and modernized
    \code{xcms} user interface which will eventually replace the
    \code{\link{findPeaks}} methods. It supports chromatographic peak
    detection on
    \code{\link{OnDiskMSnExp}} objects (defined in the
    \code{MSnbase} package). All of the settings to the algorithm can be
    passed with a \code{CentWavePredIsoParam} object.
}
\examples{

## Create a param object
p <- CentWavePredIsoParam(maxCharge = 4)
## Change snthresh parameter
snthresh(p) <- 25
p

}
\seealso{
The \code{\link{do_findChromPeaks_centWaveWithPredIsoROIs}} core
    API function and \code{\link{findPeaks.centWave}} for the old user
    interface. \code{\link{CentWaveParam}} for the class the
    \code{CentWavePredIsoParam} extends.

\code{\link{XCMSnExp}} for the object containing the results of
    the peak detection.

Other peak detection methods: 
\code{\link{findChromPeaks}()},
\code{\link{findChromPeaks-centWave}},
\code{\link{findChromPeaks-massifquant}},
\code{\link{findChromPeaks-matchedFilter}},
\code{\link{findPeaks-MSW}}
}
\author{
Hendrik Treutler, Johannes Rainer
}
\concept{peak detection methods}
