% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-Chromatogram.R
\name{findChromPeaks,Chromatogram,MatchedFilterParam-method}
\alias{findChromPeaks,Chromatogram,MatchedFilterParam-method}
\title{matchedFilter-based peak detection in purely chromatographic data}
\usage{
\S4method{findChromPeaks}{Chromatogram,MatchedFilterParam}(object, param, ...)
}
\arguments{
\item{object}{a \link{Chromatogram} or \link{MChromatograms} object.}

\item{param}{a \link{MatchedFilterParam} object specifying the settings for the
peak detection. See \code{\link[=peaksWithMatchedFilter]{peaksWithMatchedFilter()}} for the description of
arguments used for peak detection.}

\item{...}{currently ignored.}
}
\value{
If called on a \code{Chromatogram} object, the method returns a \code{matrix} with
the identified peaks. Columns \code{"mz"}, \code{"mzmin"} and \code{"mzmax"} in
the \code{chromPeaks()} peak matrix provide the mean m/z and the maximum and
minimum m/z value of the \code{Chromatogram} object. See
\code{\link[=peaksWithMatchedFilter]{peaksWithMatchedFilter()}} for details on the remaining columns.
}
\description{
\code{findChromPeaks} on a \link{Chromatogram} or \link{MChromatograms} object with a
\link{MatchedFilterParam} parameter object performs matchedFilter-based peak
detection on purely chromatographic data. See \link{matchedFilter} for details
on the method and \link{MatchedFilterParam} for details on the parameter class.
Note that not all settings from the \code{MatchedFilterParam} will be used.
See \code{\link[=peaksWithMatchedFilter]{peaksWithMatchedFilter()}} for the arguments used for peak detection
on purely chromatographic data.
}
\examples{

## Loading a test data set with identified chromatographic peaks
faahko_sub <- loadXcmsData("faahko_sub2")
faahko_sub <- filterRt(faahko_sub, c(2500, 3700))

##
od <- as(filterFile(faahko_sub, 1L), "MsExperiment")

## Extract chromatographic data for a small m/z range
chr <- chromatogram(od, mz = c(272.1, 272.3))[1, 1]

## Identify peaks with default settings
xchr <- findChromPeaks(chr, MatchedFilterParam())

## Plot the identified peaks
plot(xchr)
}
\seealso{
\code{\link[=peaksWithMatchedFilter]{peaksWithMatchedFilter()}} for the downstream function and
\link{matchedFilter} for details on the method.
}
\author{
Johannes Rainer
}
