% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R,
%   R/methods-XCMSnExp.R
\name{featureSpectra}
\alias{featureSpectra}
\alias{featureSpectra,XcmsExperiment-method}
\alias{featureSpectra,XCMSnExp-method}
\title{Extract spectra associated with features}
\usage{
featureSpectra(object, ...)

\S4method{featureSpectra}{XcmsExperiment}(
  object,
  msLevel = 2L,
  expandRt = 0,
  expandMz = 0,
  ppm = 0,
  skipFilled = FALSE,
  return.type = c("Spectra", "List"),
  features = character(),
  featureColumns = c("rtmed", "mzmed"),
  ...
)

\S4method{featureSpectra}{XCMSnExp}(
  object,
  msLevel = 2L,
  expandRt = 0,
  expandMz = 0,
  ppm = 0,
  skipFilled = FALSE,
  return.type = c("MSpectra", "Spectra", "list", "List"),
  features = character(),
  ...
)
}
\arguments{
\item{object}{\link{XcmsExperiment} or \link{XCMSnExp} object with feature defitions.}

\item{...}{additional arguments to be passed along to \code{\link[=chromPeakSpectra]{chromPeakSpectra()}},
such as \code{method}.}

\item{msLevel}{\code{integer(1)} defining the MS level of the spectra that
should be returned.}

\item{expandRt}{\code{numeric(1)} to expand the retention time range of each
peak by a constant value on each side.}

\item{expandMz}{\code{numeric(1)} to expand the m/z range of each peak by a
constant value on each side.}

\item{ppm}{\code{numeric(1)} to expand the m/z range of each peak (on each side)
by a value dependent on the peak's m/z.}

\item{skipFilled}{\code{logical(1)} whether spectra for filled-in peaks should
be reported or not.}

\item{return.type}{\code{character(1)} defining the type of result object that
should be returned.}

\item{features}{\code{character}, \code{logical} or \code{integer} allowing to specify a
subset of features in \code{featureDefinitions} for which spectra should
be returned (providing either their ID, a logical vector same length
than \code{nrow(featureDefinitions(x))} or their index in
\code{featureDefinitions(x)}). This parameter overrides \code{skipFilled} and is
only supported for \code{return.type} being either \code{"Spectra"} or \code{"List"}.}

\item{featureColumns}{\code{character} vector with the names of the columns
from \code{featureDefinitions} that should be added to the returned spectra
object. The columns will be named as they are written in the
\code{featureDefinitions} object with the prefix \verb{"feature_}.
Defaults to \code{c("mzmed", "rtmed")}.}
}
\value{
The function returns either a \code{\link[Spectra:Spectra]{Spectra::Spectra()}} (for
\code{return.type = "Spectra"})
or a \code{List} of \code{Spectra} (for \code{return.type = "List"}). For the latter,
the order and the length matches parameter \code{features} (or if no \code{features}
is defined the order of the features in \code{featureDefinitions(object)}).

Spectra variables \code{"chrom_peak_id"} and \code{"feature_id"} define to which
chromatographic peak or feature each individual spectrum is associated
with.
}
\description{
This function returns spectra associated with the identified features in
the input object. By default, spectra are returned for all features (from
all MS levels), but parameter \code{features} allows to specify/select features
for which the result should be returned.
Parameter \code{msLevel} allows to define whether MS level 1 or 2 spectra
should be returned. For \code{msLevel = 1L} all MS1 spectra within the
retention time range of each chromatographic peak (in that respective
data file) associated with a feature are returned. Note that for samples
in which no peak was identified (or even filled-in) no spectra are
returned. For \code{msLevel = 2L} all MS2 spectra with a retention time within
the retention time range and their precursor m/z within the m/z range of
any chromatographic peak of a feature are returned.

See also \code{\link[=chromPeakSpectra]{chromPeakSpectra()}} (used internally to extract spectra for
each chromatographic peak of a feature) for additional information,
specifically also on parameter \code{method}. By default (\code{method = "all"})
all spectra associated with any of the chromatographic peaks of a
feature are returned. With any other option for \code{method}, a single
spectrum \strong{per chromatographic peak} will be returned (hence multiple
spectra per feature).

The information from \code{featureDefinitions} for each feature can be included
in the returned \code{\link[Spectra:Spectra]{Spectra::Spectra()}} object using the \code{featureColumns}
parameter.
This is useful for keeping details such as the median retention time (\code{rtmed})
or median m/z (\code{mzmed}). The columns will retain their names as specified
in the \code{featureDefinitions} object, prefixed by \code{"feature_"}
(e.g., \code{"feature_mzmed"}). Additionally, the \emph{feature ID} (i.e., the row
name of the feature in the \code{featureDefinitions} data.frame) is always added
as a metadata column named \code{"feature_id"}.

See also \code{\link[=chromPeakSpectra]{chromPeakSpectra()}}, as it supports a similar parameter for
including columns from the chromatographic peaks in the returned spectra
object.
These parameters can be used in combination to include information from both
the chromatographic peaks and the features in the returned
\code{\link[Spectra:Spectra]{Spectra::Spectra()}}.
The \emph{peak ID} (i.e., the row name of the peak in the \code{chromPeaks} matrix)
is added as a metadata column named \code{"chrom_peak_id"}.
}
\author{
Johannes Rainer
}
