% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R,
%   R/functions-Params.R
\name{chromPeakSummary}
\alias{chromPeakSummary}
\alias{chromPeakSummary,XcmsExperiment,BetaDistributionParam-method}
\alias{BetaDistributionParam}
\title{Chromatographic peak summaries}
\usage{
chromPeakSummary(object, param, ...)

\S4method{chromPeakSummary}{XcmsExperiment,BetaDistributionParam}(
  object,
  param,
  msLevel = 1L,
  chunkSize = 2L,
  BPPARAM = bpparam()
)

BetaDistributionParam()
}
\arguments{
\item{object}{an \emph{xcms} result object containing information on
identified chromatographic peaks.}

\item{param}{a parameter object defining the method/summaries that should
be calculated (see description above for supported parameter classes).}

\item{...}{additional arguments passed to the method implementation.}

\item{msLevel}{\code{integer(1)} with the MS level of the chromatographic peaks
on which the metric should be calculated.}

\item{chunkSize}{\code{integer(1)} defining the number of samples from which data
should be loaded and processed at a time.}

\item{BPPARAM}{Parallel processing setup. See
\code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for details.}
}
\value{
A \code{matrix} or \code{data.frame} with the same number of rows as there are
chromatographic peaks. Columns contain the calculated values. The number of
columns, their names and content depend on the used parameter object. See
the respective documentation above for more details.
}
\description{
The \code{chromPeakSummary()} method calculates summary statistics or other
metrics for each of the identified chromatographic peaks in an \emph{xcms} result
object, such as the \code{\link[=XcmsExperiment]{XcmsExperiment()}}. Different metrics can be calculated,
depending upon (and configured by) using dedicated \emph{parameter} classes. As a
result, the method returns a \code{matrix} or \code{data.frame} with one row per
chromatographic peak. Each column contains calculated values, depending on
the used method/parameter class.

Currently implemented methods/parameter classes are:
\itemize{
\item \code{BetaDistributionParam}: calculates the \emph{beta_cor} and \emph{beta_snr} quality
metrics as described in Kumler 2023 representing the result from a
(correlation) test of similarity (using Pearson's correlation coefficient)
to a bell curve and the signal-to-noise ratio calculated on the residuals
of this test.
}
}
\references{
Kumler W, Hazelton B J and Ingalls A E (2023) "Picky with peakpicking:
assessing chromatographic peak quality with simple metrics in metabolomics"
\emph{BMC Bioinformatics} 24(1):404. doi: 10.1186/s12859-023-05533-4
}
\author{
Pablo Vangeenderhuysen, Johannes Rainer, William Kumler
}
