% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-binning.R
\name{breaks_on_binSize}
\alias{breaks_on_binSize}
\title{Generate breaks for binning using a defined bin size.}
\usage{
breaks_on_binSize(fromX, toX, binSize)
}
\arguments{
\item{fromX}{numeric(1) specifying the lowest value for the bins.}

\item{toX}{numeric(1) specifying the largest value for the bins.}

\item{binSize}{numeric(1) defining the size of a bin.}
}
\value{
A numeric vector defining the lower and upper bounds of the bins.
}
\description{
Defines breaks for \code{binSize} sized bins for values ranging
from \code{fromX} to \code{toX}.
}
\details{
This function creates breaks for bins of size \code{binSize}. The
function ensures that the full data range is included in the bins, i.e. the
last value (upper boundary of the last bin) is always equal \code{toX}. This
however means that the size of the last bin will not always be equal to the
desired bin size.
See examples for more details and a comparisom to R's \code{seq} function.
}
\examples{
## Define breaks with a size of 0.13 for a data range from 1 to 10:
breaks_on_binSize(1, 10, 0.13)
## The size of the last bin is however larger than 0.13:
diff(breaks_on_binSize(1, 10, 0.13))
## If we would use seq, the max value would not be included:
seq(1, 10, by = 0.13)

## In the next example we use binSize that leads to an additional last bin with
## a smaller binSize:
breaks_on_binSize(1, 10, 0.51)
## Again, the max value is included, but the size of the last bin is < 0.51.
diff(breaks_on_binSize(1, 10, 0.51))
## Using just seq would result in the following bin definition:
seq(1, 10, by = 0.51)
## Thus it defines one bin (break) less.
}
\seealso{
\code{\link{binYonX}} for a binning function.

Other functions to define bins: 
\code{\link{breaks_on_nBins}()}
}
\author{
Johannes Rainer
}
\concept{functions to define bins}
