% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MsExperiment.R, R/methods-xcmsRaw.R
\name{profMat,MsExperiment-method}
\alias{profMat,MsExperiment-method}
\alias{profMat-xcmsSet}
\alias{profile-matrix}
\alias{profMat}
\alias{profMat,xcmsRaw-method}
\title{The profile matrix}
\usage{
\S4method{profMat}{MsExperiment}(
  object,
  method = "bin",
  step = 0.1,
  baselevel = NULL,
  basespace = NULL,
  mzrange. = NULL,
  fileIndex = seq_along(object),
  chunkSize = 1L,
  msLevel = 1L,
  BPPARAM = bpparam(),
  ...
)

\S4method{profMat}{xcmsRaw}(object, method, step, baselevel, basespace, mzrange.)
}
\arguments{
\item{object}{An \code{xcmsRaw}, \code{OnDiskMSnExp}, \code{XCMSnExp}, \code{MsExperiment} or
\code{XcmsExperiment}  object.}

\item{method}{\code{character(1)} defining the profile matrix generation method.
Allowed are \code{"bin"}, \code{"binlin"}, \code{"binlinbase"} and \code{"intlin"}.
See details section for more information.}

\item{step}{\code{numeric(1)} representing the m/z bin size.}

\item{baselevel}{\code{numeric(1)} representing the base value to which
empty elements (i.e. m/z bins without a measured intensity) should be
set. Only considered if \code{method = "binlinbase"}. See
\code{baseValue} parameter of \code{\link[=imputeLinInterpol]{imputeLinInterpol()}} for more
details.}

\item{basespace}{\code{numeric(1)} representing the m/z length after
which the signal will drop to the base level. Linear interpolation will
be used between consecutive data points falling within
\code{2 * basespace} to each other. Only considered if
\code{method = "binlinbase"}. If not specified, it defaults to
\code{0.075}. Internally this parameter is translated into the
\code{distance} parameter of the \code{\link[=imputeLinInterpol]{imputeLinInterpol()}}
function by \code{distance = floor(basespace / step)}. See
\code{distance} parameter of \code{\link[=imputeLinInterpol]{imputeLinInterpol()}} for more
details.}

\item{mzrange.}{Optional \code{numeric(2)} manually specifying the mz value range
to be used for binnind. If not provided, the whole m/z value range is
used.}

\item{fileIndex}{For \code{MsExperiment} or \code{XcmsExperiment}: \code{integer} defining
the idex (or indices) of the sample(s) from which the profile matrix
should be created.}

\item{chunkSize}{For \code{MsExperiment} or \code{XcmsExperiment}: \code{integer(1)}
defining the number of files from which data should be loaded and
processed in one iteration. By default one file at a time is processed
\code{chunkSize = 1L} which requires less memory. For parallel processing,
the \code{chunkSize} should be \code{>=} than the number of parallel processes
that should be used.}

\item{msLevel}{For \code{MsExperiment} or \code{XcmsExperiment}: \code{integer(1)} defining
the MS level from which the profile matrix should be generated.}

\item{BPPARAM}{For \code{MsExperiment} or \code{XcmsExperiment}: parallel processing
setup. See \code{\link[=bpparam]{bpparam()}} for more details. Defaults to
\code{BPPARAM = bpparam()}.}

\item{...}{ignored.}
}
\value{
\code{profMat} returns the profile matrix (rows representing scans,
columns equally spaced m/z values). For \code{object} being a \code{MsExperiment}
or \code{XcmsExperiment}, the method returns a \code{list} of profile matrices,
one for each file (sample).
}
\description{
The \emph{profile} matrix is an n x m matrix, n (rows)
representing equally spaced m/z values (bins) and m (columns) the
retention time of the corresponding scans. Each cell contains the maximum
intensity measured for the specific scan and m/z values falling within
the m/z bin.

\if{html}{\out{<div class="sourceCode">}}\preformatted{The `profMat` method creates a new profile matrix or returns the
profile matrix within the object's `@env` slot, if available.
Settings for the profile matrix generation, such as `step` (the bin
size), `method` or additional settings are extracted from the
respective slots of the `xcmsRaw` object.
Alternatively it is possible to specify all of the settings as
additional parameters.

For [MsExperiment()] or [XcmsExperiment()] objects, the method returns
a `list` of profile matrices, one for each sample in `object`. Using
parameter `fileIndex` it is also possible to create a profile matrix only
for selected samples (files).
}\if{html}{\out{</div>}}
}
\details{
Profile matrix generation methods:
\itemize{
\item \code{"bin"}: The default profile matrix generation method that does a
simple binning, i.e. aggregating of intensity values falling within an
m/z bin.
\item \code{"binlin"}: Binning followed by linear interpolation to impute missing
values. The value for m/z bins without a measured intensity are inferred
by a linear interpolation between neighboring bins with a measured
intensity.
\item \code{"binlinbase"}: Binning followed by a linear interpolation to impute
values for empty elements (m/z bins) within a user-definable proximity to
non-empty elements while stetting the element's value to the
\code{baselevel} otherwise. See \code{impute = "linbase"} parameter of
\code{\link[=imputeLinInterpol]{imputeLinInterpol()}} for more details.
\item \code{"intlin"}: Set the elements' values to the integral of the linearly
interpolated data from plus to minus half the step size.
}
}
\examples{
file <- system.file('cdf/KO/ko15.CDF', package = "faahKO")
## Load the data without generating the profile matrix (profstep = 0)
xraw <- xcmsRaw(file, profstep = 0)
## Extract the profile matrix
profmat <- profMat(xraw, step = 0.3)
dim(profmat)
## If not otherwise specified, the settings from the xraw object are used:
profinfo(xraw)
## To extract a profile matrix with linear interpolation use
profmat <- profMat(xraw, step = 0.3, method = "binlin")
## Alternatively, the profMethod of the xraw objects could be changed
profMethod(xraw) <- "binlin"
profmat_2 <- profMat(xraw, step = 0.3)
all.equal(profmat, profmat_2)

}
\author{
Johannes Rainer
}
