% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-XCMSnExp.R
\name{highlightChromPeaks}
\alias{highlightChromPeaks}
\title{Add definition of chromatographic peaks to an extracted chromatogram
    plot}
\usage{
highlightChromPeaks(
  x,
  rt,
  mz,
  peakIds = character(),
  border = rep("00000040", length(fileNames(x))),
  lwd = 1,
  col = NA,
  type = c("rect", "point", "polygon"),
  whichPeaks = c("any", "within", "apex_within"),
  ...
)
}
\arguments{
\item{x}{For \code{highlightChromPeaks}: \code{XCMSnExp} object with the
detected peaks.}

\item{rt}{For \code{highlightChromPeaks}: \code{numeric(2)} with the
retention time range from which peaks should be extracted and plotted.}

\item{mz}{\code{numeric(2)} with the mz range from which the peaks should
be extracted and plotted.}

\item{peakIds}{\code{character} defining the IDs (i.e. rownames of the peak
in the \code{chromPeaks} table) of the chromatographic peaks to be
highlighted in a plot.}

\item{border}{colors to be used to color the border of the rectangles/peaks.
Has to be equal to the number of samples in \code{x}.}

\item{lwd}{\code{numeric(1)} defining the width of the line/border.}

\item{col}{For \code{highlightChromPeaks}: color to be used to fill the
rectangle (if \code{type = "rect"}) or the peak
(for \code{type = "polygon"}).}

\item{type}{the plotting type. See \code{\link{plot}} in base grapics for
more details.
For \code{highlightChromPeaks}: \code{character(1)} defining how the peak
should be highlighted: \code{type = "rect"} draws a rectangle
representing the peak definition, \code{type = "point"} indicates a
chromatographic peak with a single point at the position of the peak's
\code{"rt"} and \code{"maxo"} and \code{type = "polygon"} will highlight
the peak shape. For \code{type = "polygon"} the color of the border and
area can be defined with parameters \code{"border"} and \code{"col"},
respectively.}

\item{whichPeaks}{\code{character(1)} specifying how peaks are called to be
located within the region defined by \code{mz} and \code{rt}. Can be
one of \code{"any"}, \code{"within"}, and \code{"apex_within"} for all
peaks that are even partially overlapping the region, peaks that are
completely within the region, and peaks for which the apex is within
the region. This parameter is passed to the \code{type} argument of the
\code{\link{chromPeaks}} function. See related documentation for more
information and examples.}

\item{...}{additional parameters to the \code{\link{matplot}} or \code{plot}
function.}
}
\description{
The \code{highlightChromPeaks} function adds chromatographic
peak definitions to an existing plot, such as one created by the
\code{plot} method on a \code{\link{Chromatogram}} or
\code{\link{MChromatograms}} object.
}
\examples{

## Load a test data set with detected peaks
library(MSnbase)
data(faahko_sub)
## Update the path to the files for the local system
dirname(faahko_sub) <- system.file("cdf/KO", package = "faahKO")

## Disable parallel processing for this example
register(SerialParam())

## Extract the ion chromatogram for one chromatographic peak in the data.
chrs <- chromatogram(faahko_sub, rt = c(2700, 2900), mz = 335)

plot(chrs)

## Extract chromatographic peaks for the mz/rt range (if any).
chromPeaks(faahko_sub, rt = c(2700, 2900), mz = 335)

## Highlight the chromatographic peaks in the area
## Show the peak definition with a rectangle
highlightChromPeaks(faahko_sub, rt = c(2700, 2900), mz = 335)

## Color the actual peak
highlightChromPeaks(faahko_sub, rt = c(2700, 2900), mz = 335,
    col = c("#ff000020", "#00ff0020"), type = "polygon")
}
\author{
Johannes Rainer
}
