% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/XcmsExperiment.R,
%   R/functions-Params.R, R/methods-Params.R, R/methods-XCMSnExp.R
\name{groupChromPeaks}
\alias{groupChromPeaks}
\alias{PeakDensityParam-class}
\alias{NearestPeaksParam-class}
\alias{MzClustParam-class}
\alias{groupChromPeaks,XcmsExperiment,Param-method}
\alias{PeakDensityParam}
\alias{MzClustParam}
\alias{NearestPeaksParam}
\alias{sampleGroups,PeakDensityParam-method}
\alias{sampleGroups}
\alias{sampleGroups<-,PeakDensityParam-method}
\alias{sampleGroups<-}
\alias{bw,PeakDensityParam-method}
\alias{bw}
\alias{bw<-,PeakDensityParam-method}
\alias{bw<-}
\alias{minFraction,PeakDensityParam-method}
\alias{minFraction}
\alias{minFraction<-,PeakDensityParam-method}
\alias{minFraction<-}
\alias{minSamples,PeakDensityParam-method}
\alias{minSamples}
\alias{minSamples<-,PeakDensityParam-method}
\alias{minSamples<-}
\alias{binSize,PeakDensityParam-method}
\alias{binSize<-,PeakDensityParam-method}
\alias{maxFeatures,PeakDensityParam-method}
\alias{maxFeatures}
\alias{maxFeatures<-,PeakDensityParam-method}
\alias{maxFeatures<-}
\alias{ppm,PeakDensityParam-method}
\alias{sampleGroups,MzClustParam-method}
\alias{sampleGroups<-,MzClustParam-method}
\alias{ppm,MzClustParam-method}
\alias{ppm<-,MzClustParam-method}
\alias{absMz,MzClustParam-method}
\alias{absMz}
\alias{absMz<-,MzClustParam-method}
\alias{absMz<-}
\alias{minFraction,MzClustParam-method}
\alias{minFraction<-,MzClustParam-method}
\alias{minSamples,MzClustParam-method}
\alias{minSamples<-,MzClustParam-method}
\alias{sampleGroups,NearestPeaksParam-method}
\alias{sampleGroups<-,NearestPeaksParam-method}
\alias{mzVsRtBalance,NearestPeaksParam-method}
\alias{mzVsRtBalance}
\alias{mzVsRtBalance<-,NearestPeaksParam-method}
\alias{mzVsRtBalance<-}
\alias{absMz,NearestPeaksParam-method}
\alias{absMz<-,NearestPeaksParam-method}
\alias{absRt,NearestPeaksParam-method}
\alias{absRt}
\alias{absRt<-,NearestPeaksParam-method}
\alias{absRt<-}
\alias{kNN,NearestPeaksParam-method}
\alias{kNN}
\alias{kNN<-,NearestPeaksParam-method}
\alias{kNN<-}
\alias{as.list,PeakDensityParam-method}
\alias{groupChromPeaks,XCMSnExp,PeakDensityParam-method}
\alias{groupChromPeaks,XCMSnExp,MzClustParam-method}
\alias{groupChromPeaks,XCMSnExp,NearestPeaksParam-method}
\title{Correspondence: group chromatographic peaks across samples}
\usage{
groupChromPeaks(object, param, ...)

\S4method{groupChromPeaks}{XcmsExperiment,Param}(object, param, msLevel = 1L, add = FALSE)

PeakDensityParam(
  sampleGroups = numeric(),
  bw = 30,
  minFraction = 0.5,
  minSamples = 1,
  binSize = 0.25,
  ppm = 0,
  maxFeatures = 50
)

MzClustParam(
  sampleGroups = numeric(),
  ppm = 20,
  absMz = 0,
  minFraction = 0.5,
  minSamples = 1
)

NearestPeaksParam(
  sampleGroups = numeric(),
  mzVsRtBalance = 10,
  absMz = 0.2,
  absRt = 15,
  kNN = 10
)

\S4method{sampleGroups}{PeakDensityParam}(object)

\S4method{sampleGroups}{PeakDensityParam}(object) <- value

\S4method{bw}{PeakDensityParam}(object)

\S4method{bw}{PeakDensityParam}(object) <- value

\S4method{minFraction}{PeakDensityParam}(object)

\S4method{minFraction}{PeakDensityParam}(object) <- value

\S4method{minSamples}{PeakDensityParam}(object)

\S4method{minSamples}{PeakDensityParam}(object) <- value

\S4method{binSize}{PeakDensityParam}(object)

\S4method{binSize}{PeakDensityParam}(object) <- value

\S4method{maxFeatures}{PeakDensityParam}(object)

\S4method{maxFeatures}{PeakDensityParam}(object) <- value

\S4method{ppm}{PeakDensityParam}(object)

\S4method{sampleGroups}{MzClustParam}(object)

\S4method{sampleGroups}{MzClustParam}(object) <- value

\S4method{ppm}{MzClustParam}(object)

\S4method{ppm}{MzClustParam}(object) <- value

\S4method{absMz}{MzClustParam}(object)

\S4method{absMz}{MzClustParam}(object) <- value

\S4method{minFraction}{MzClustParam}(object)

\S4method{minFraction}{MzClustParam}(object) <- value

\S4method{minSamples}{MzClustParam}(object)

\S4method{minSamples}{MzClustParam}(object) <- value

\S4method{sampleGroups}{NearestPeaksParam}(object)

\S4method{sampleGroups}{NearestPeaksParam}(object) <- value

\S4method{mzVsRtBalance}{NearestPeaksParam}(object)

\S4method{mzVsRtBalance}{NearestPeaksParam}(object) <- value

\S4method{absMz}{NearestPeaksParam}(object)

\S4method{absMz}{NearestPeaksParam}(object) <- value

\S4method{absRt}{NearestPeaksParam}(object)

\S4method{absRt}{NearestPeaksParam}(object) <- value

\S4method{kNN}{NearestPeaksParam}(object)

\S4method{kNN}{NearestPeaksParam}(object) <- value

\S4method{as.list}{PeakDensityParam}(x, ...)

\S4method{groupChromPeaks}{XCMSnExp,PeakDensityParam}(object, param, msLevel = 1L, add = FALSE)

\S4method{groupChromPeaks}{XCMSnExp,MzClustParam}(object, param, msLevel = 1L)

\S4method{groupChromPeaks}{XCMSnExp,NearestPeaksParam}(object, param, msLevel = 1L, add = FALSE)
}
\arguments{
\item{object}{The data object on which the correspondence analysis should be
performed. Can be an \code{\link[=XCMSnExp]{XCMSnExp()}}, \code{\link[=XcmsExperiment]{XcmsExperiment()}} object.}

\item{param}{The parameter object selecting and configuring the algorithm.}

\item{...}{Optional parameters.}

\item{msLevel}{\code{integer(1)} defining the MS level on which the
chromatographic peak detection should be performed.}

\item{add}{\code{logical(1)} (if \code{object} contains already chromatographic peaks,
i.e. is either an \code{XCMSnExp} or \code{XcmsExperiment}) whether chromatographic
peak detection results should be \strong{added} to existing results. By
default (\code{add = FALSE}) any additional \code{findChromPeaks} call on a result
object will remove previous results.}

\item{sampleGroups}{For \code{PeakDensityParam}: A vector of the same length than
samples defining the sample group assignments (i.e. which samples
belong to which sample group). This parameter is mandatory for
\code{PeakDensityParam} and has to be defined also if there is no sample
grouping in the experiment (in which case all samples should be
assigned to the same group). Samples for which a \code{NA} is provided will
not be considered in the feature definitions step. Providing \code{NA} for
all blanks in an experiment will for example avoid features to be
defined for signals (chrom peaks) present only in blank samples.}

\item{bw}{For \code{PeakDensityParam}: \code{numeric(1)} defining the bandwidth
(standard deviation ot the smoothing kernel) to be used. This argument
is passed to the [density() method.}

\item{minFraction}{For \code{PeakDensityParam}: \code{numeric(1)} defining the minimum
fraction of samples in at least one sample group in which the peaks
have to be present to be considered as a peak group (feature).}

\item{minSamples}{For \code{PeakDensityParam}: \code{numeric(1)} with the minimum
number of samples in at least one sample group in which the peaks have
to be detected to be considered a peak group (feature).}

\item{binSize}{For \code{PeakDensityParam}: \code{numeric(1)} defining the size of the
overlapping slices in m/z dimension.}

\item{ppm}{For \code{MzClustParam}: \code{numeric(1)} representing the relative m/z
error for the clustering/grouping (in parts per million).
For \code{PeakDensityParam}: \code{numeric(1)} to define m/z-dependent, increasing
m/z bin sizes. If \code{ppm = 0} (the default) m/z bins are defined by the
sequence of values from the smallest to the larges m/z value with a
constant bin size of \code{binSize}. For \code{ppm} > 0 the size of each bin is
increased in addition by the \code{ppm} of the (upper) m/z boundary of the
bin. The maximal bin size (used for the largest m/z values) would then
be \code{binSize} plus \code{ppm} parts-per-million of the largest m/z value of
all peaks in the data set.}

\item{maxFeatures}{For \code{PeakDensityParam}: \code{numeric(1)} with the maximum
number of peak groups to be identified in a single mz slice.}

\item{absMz}{For \code{NearestPeaksParam} and \code{MzClustParam}: \code{numeric(1)}
maximum tolerated distance for m/z values.}

\item{mzVsRtBalance}{For \code{NearestPeaksParam}: \code{numeric(1)} representing the
factor by which m/z values are multiplied before calculating the
(euclician) distance between two peaks.}

\item{absRt}{For \code{NearestPeaksParam}: \code{numeric(1)} maximum tolerated
distance for retention times.}

\item{kNN}{For \code{NearestPeaksParam}: \code{integer(1)} representing the number of
nearest neighbors to check.}

\item{value}{The value for the slot.}

\item{x}{The parameter object.}
}
\value{
For \code{groupChromPeaks}: either an \code{\link[=XcmsExperiment]{XcmsExperiment()}} or \code{\link[=XCMSnExp]{XCMSnExp()}}
object with the correspondence result.
}
\description{
The \code{groupChromPeaks} method performs a correspondence analysis i.e., it
groups chromatographic peaks across samples to define the LC-MS \emph{features}.
The correspondence algorithm can be selected, and configured, using the
\code{param} argument. See documentation of \code{\link[=XcmsExperiment]{XcmsExperiment()}} and \code{\link[=XCMSnExp]{XCMSnExp()}}
for information on how to access and extract correspondence results.

The correspondence analysis can be performed on chromatographic peaks of
any MS level (if present and if chromatographic peak detection has been
performed for that MS level) defining features combining these peaks. The
MS level can be selected with the parameter \code{msLevel}. By default, calling
\code{groupChromPeaks} will remove any previous correspondence results. This can
be disabled with \code{add = TRUE}, which will add newly defined features to
already present feature definitions.

Supported \code{param} objects are:
\itemize{
\item \code{PeakDensityParam}: correspondence using the \emph{peak density} method
(Smith 2006) that groups chromatographic peaks along the retention time
axis within slices of (partially overlapping) m/z ranges. By default,
these m/z ranges (bins) have a constant size. By setting \code{ppm} to a value
larger than 0, m/z dependent bin sizes can be used instead (better
representing the m/z dependent measurement error of some MS instruments).
All peaks (from the same or from different samples) with their apex
position being close on the retention time axis are grouped into a LC-MS
feature. Only samples with non-missing sample group assignment (i.e. for
which the value provided with parameter \code{sampleGroups} is different than
\code{NA}) are considered and counted for the feature definition. This allows
to exclude certain samples or groups (e.g. blanks) from the feature
definition avoiding thus features with only detected peaks in these. Note
that this affects only the \strong{definition} of \strong{new} features.
Chromatographic peaks in these samples will still be assigned to features
which were defined based on the other samples.
See in addition \code{\link[=do_groupChromPeaks_density]{do_groupChromPeaks_density()}} for the core API
function.
\item \code{NearestPeaksParam}: performs peak grouping based on the proximity of
chromatographic peaks from different samples in the m/z - rt space similar
to the correspondence method of \emph{mzMine} (Katajamaa 2006). The method
creates first a \emph{master peak list} consisting of all chromatographic peaks
from the sample with the most detected peaks and iteratively calculates
distances to peaks from the sample with the next most number of peaks
grouping peaks together if their \emph{distance} is smaller than the provided
thresholds.
See in addition \code{\link[=do_groupChromPeaks_nearest]{do_groupChromPeaks_nearest()}} for the core API function.
\item \code{MzClustParam}: performs high resolution peak grouping for
\strong{single spectrum} metabolomics data (Kazmi 2006). This method should
\strong{only} be used for such data as the retention time is not considered
in the correspondence analysis.
See in addition \code{\link[=do_groupPeaks_mzClust]{do_groupPeaks_mzClust()}} for the core API function.
}

For specific examples and description of the method and settings see the
help pages of the individual parameter classes listed above.
}
\references{
Smith, C.A., Want E.J., O'Maille G., Abagyan R., and Siuzdak G. (2006)
"XCMS: Processing Mass Spectrometry Data for Metabolite Profiling Using
Nonlinear Peak Alignment, Matching, and Identification" \emph{Anal. Chem.}
78:779-787.

Katajamaa, M., Miettinen, J., Oresic, M. (2006) "MZmine: Toolbox for
processing and visualization of mass spectrometry based molecular profile
data". \emph{Bioinformatics}, 22:634-636.

Kazmi S. A., Ghosh, S., Shin, D., Hill, D.W., and Grant, D.F. (2006)
"Alignment of high resolution mass spectra: development of a
heuristic approach for metabolomics. \emph{Metabolomics} Vol. 2, No. 2, 75-83.
}
\author{
Colin Smith, Johannes Rainer
}
\concept{peak grouping methods}
