% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R, R/functions-Params.R,
%   R/methods-OnDiskMSnExp.R, R/methods-Params.R
\docType{class}
\name{findPeaks-MSW}
\alias{findPeaks-MSW}
\alias{MSW}
\alias{MSWParam-class}
\alias{MSWParam}
\alias{findChromPeaks,OnDiskMSnExp,MSWParam-method}
\alias{snthresh,MSWParam-method}
\alias{snthresh<-,MSWParam-method}
\alias{verboseColumns,MSWParam-method}
\alias{verboseColumns<-,MSWParam-method}
\alias{scales,MSWParam-method}
\alias{scales}
\alias{scales<-,MSWParam-method}
\alias{scales<-}
\alias{nearbyPeak,MSWParam-method}
\alias{nearbyPeak}
\alias{nearbyPeak<-,MSWParam-method}
\alias{nearbyPeak<-}
\alias{peakScaleRange,MSWParam-method}
\alias{peakScaleRange}
\alias{peakScaleRange<-,MSWParam-method}
\alias{peakScaleRange<-}
\alias{ampTh,MSWParam-method}
\alias{ampTh}
\alias{ampTh<-,MSWParam-method}
\alias{ampTh<-}
\alias{minNoiseLevel,MSWParam-method}
\alias{minNoiseLevel}
\alias{minNoiseLevel<-,MSWParam-method}
\alias{minNoiseLevel<-}
\alias{ridgeLength,MSWParam-method}
\alias{ridgeLength}
\alias{ridgeLength<-,MSWParam-method}
\alias{ridgeLength<-}
\alias{peakThr,MSWParam-method}
\alias{peakThr}
\alias{peakThr<-,MSWParam-method}
\alias{peakThr<-}
\alias{tuneIn,MSWParam-method}
\alias{tuneIn}
\alias{tuneIn<-,MSWParam-method}
\alias{tuneIn<-}
\alias{addParams,MSWParam-method}
\alias{addParams}
\alias{addParams<-,MSWParam-method}
\alias{addParams<-}
\title{Single-spectrum non-chromatography MS data peak detection}
\usage{
MSWParam(
  snthresh = 3,
  verboseColumns = FALSE,
  scales = c(1, seq(2, 30, 2), seq(32, 64, 4)),
  nearbyPeak = TRUE,
  peakScaleRange = 5,
  ampTh = 0.01,
  minNoiseLevel = ampTh/snthresh,
  ridgeLength = 24,
  peakThr = NULL,
  tuneIn = FALSE,
  ...
)

\S4method{findChromPeaks}{OnDiskMSnExp,MSWParam}(
  object,
  param,
  BPPARAM = bpparam(),
  return.type = "XCMSnExp",
  msLevel = 1L,
  ...
)

\S4method{snthresh}{MSWParam}(object)

\S4method{snthresh}{MSWParam}(object) <- value

\S4method{verboseColumns}{MSWParam}(object)

\S4method{verboseColumns}{MSWParam}(object) <- value

\S4method{scales}{MSWParam}(object)

\S4method{scales}{MSWParam}(object) <- value

\S4method{nearbyPeak}{MSWParam}(object)

\S4method{nearbyPeak}{MSWParam}(object) <- value

\S4method{peakScaleRange}{MSWParam}(object)

\S4method{peakScaleRange}{MSWParam}(object) <- value

\S4method{ampTh}{MSWParam}(object)

\S4method{ampTh}{MSWParam}(object) <- value

\S4method{minNoiseLevel}{MSWParam}(object)

\S4method{minNoiseLevel}{MSWParam}(object) <- value

\S4method{ridgeLength}{MSWParam}(object)

\S4method{ridgeLength}{MSWParam}(object) <- value

\S4method{peakThr}{MSWParam}(object)

\S4method{peakThr}{MSWParam}(object) <- value

\S4method{tuneIn}{MSWParam}(object)

\S4method{tuneIn}{MSWParam}(object) <- value

\S4method{addParams}{MSWParam}(object)

\S4method{addParams}{MSWParam}(object) <- value
}
\arguments{
\item{snthresh}{\code{numeric(1)} defining the signal to noise ratio cutoff.}

\item{verboseColumns}{\code{logical(1)} whether additional peak meta data
columns should be returned.}

\item{scales}{Numeric defining the scales of the continuous wavelet
transform (CWT).}

\item{nearbyPeak}{logical(1) whether to include nearby peaks of
major peaks.}

\item{peakScaleRange}{numeric(1) defining the scale range of the
peak (larger than 5 by default).}

\item{ampTh}{numeric(1) defining the minimum required relative
amplitude of the peak (ratio of the maximum of CWT coefficients).}

\item{minNoiseLevel}{numeric(1) defining the minimum noise level
used in computing the SNR.}

\item{ridgeLength}{numeric(1) defining the minimum highest scale
of the peak in 2-D CWT coefficient matrix.}

\item{peakThr}{numeric(1) with the minimum absolute intensity
(above baseline) of peaks to be picked. If provided, the smoothing
Savitzky-Golay filter is used (in the \code{MassSpecWavelet})
package to estimate the local intensity.}

\item{tuneIn}{logical(1) whther to tune in the parameter
estimation of the detected peaks.}

\item{...}{Additional parameters to be passed to the
\code{\link{peakDetectionCWT}} and
\code{\link{identifyMajorPeaks}} functions from the
\code{MassSpecWavelet} package.}

\item{object}{For \code{findChromPeaks}: an
    \code{\link{OnDiskMSnExp}} object containing the MS- and all
    other experiment-relevant data.

    For all other methods: a parameter object.}

\item{param}{An \code{MSWParam} object containing all settings for
the algorithm.}

\item{BPPARAM}{A parameter class specifying if and how parallel processing
should be performed. It defaults to \code{\link{bpparam}}.
See documentation of the \code{BiocParallel} for more details. If
parallel processing is enabled, peak detection is performed in parallel
on several of the input samples.}

\item{return.type}{Character specifying what type of object the method should
return. Can be either \code{"XCMSnExp"} (default), \code{"list"} or
\code{"xcmsSet"}.}

\item{msLevel}{\code{integer(1)} defining the MS level on which the peak
detection should be performed. Defaults to \code{msLevel = 1}.}

\item{value}{The value for the slot.}
}
\value{
The \code{MSWParam} function returns a \code{MSWParam}
    class instance with all of the settings specified for peak detection by
    the \emph{MSW} method.

For \code{findChromPeaks}: if \code{return.type = "XCMSnExp"} an
    \code{\link{XCMSnExp}} object with the results of the peak detection.
    If \code{return.type = "list"} a list of length equal to the number of
    samples with matrices specifying the identified peaks.
    If \code{return.type = "xcmsSet"} an \code{\linkS4class{xcmsSet}} object
    with the results of the detection.
}
\description{
Perform peak detection in mass spectrometry
    direct injection spectrum using a wavelet based algorithm.

The \code{MSWParam} class allows to specify all
    settings for a peak detection using the MSW method. Instances should be
    created with the \code{MSWParam} constructor.

The \code{findChromPeaks,OnDiskMSnExp,MSWParam}
    method performs peak detection in single-spectrum non-chromatography MS
    data using functionality from the \code{MassSpecWavelet} package on all
    samples from an \code{\link{OnDiskMSnExp}} object.
    \code{\link{OnDiskMSnExp}} objects encapsule all experiment
    specific data and load the spectra data (mz and intensity values) on the
    fly from the original files applying also all eventual data
    manipulations.

\code{snthresh},\code{snthresh<-}: getter and setter for the
    \code{snthresh} slot of the object.

\code{verboseColumns},\code{verboseColumns<-}: getter and setter
    for the \code{verboseColumns} slot of the object.

\code{scales},\code{scales<-}: getter and setter for the
    \code{scales} slot of the object.

\code{nearbyPeak},\code{nearbyPeak<-}: getter and setter for the
    \code{nearbyPeak} slot of the object.

\code{peakScaleRange},\code{peakScaleRange<-}: getter and setter
    for the \code{peakScaleRange} slot of the object.

\code{ampTh},\code{ampTh<-}: getter and setter for the
    \code{ampTh} slot of the object.

\code{minNoiseLevel},\code{minNoiseLevel<-}: getter and setter
    for the \code{minNoiseLevel} slot of the object.

\code{ridgeLength},\code{ridgeLength<-}: getter and setter for
    the \code{ridgeLength} slot of the object.

\code{peakThr},\code{peakThr<-}: getter and setter for the
    \code{peakThr} slot of the object.

\code{tuneIn},\code{tuneIn<-}: getter and setter for the
    \code{tuneIn} slot of the object.

\code{addParams},\code{addParams<-}: getter and setter for the
    \code{addParams} slot of the object. This slot stores optional additional
    parameters to be passed to the
    \code{\link{identifyMajorPeaks}} and
    \code{\link{peakDetectionCWT}} functions from the
    \code{MassSpecWavelet} package.
}
\details{
This is a wrapper for the peak picker in Bioconductor's
    \code{MassSpecWavelet} package calling
    \code{\link{peakDetectionCWT}} and
    \code{\link{tuneInPeakInfo}} functions. See the
    \emph{xcmsDirect} vignette for more information.

Parallel processing (one process per sample) is supported and can
    be configured either by the \code{BPPARAM} parameter or by globally
    defining the parallel processing mode using the
    \code{\link{register}} method from the \code{BiocParallel}
    package.
}
\section{Slots}{

\describe{
\item{\code{snthresh,verboseColumns,scales,nearbyPeak,peakScaleRange,ampTh,minNoiseLevel,ridgeLength,peakThr,tuneIn,addParams}}{See corresponding parameter above.}
}}

\note{
These methods and classes are part of the updated and modernized
    \code{xcms} user interface which will eventually replace the
    \code{\link{findPeaks}} methods. It supports peak detection on
    \code{\link{OnDiskMSnExp}}
    objects (defined in the \code{MSnbase} package). All of the settings
    to the algorithm can be passed with a \code{MSWParam} object.
}
\examples{

library(MSnbase)
## Create a MSWParam object
mp <- MSWParam()
## Change snthresh parameter
snthresh(mp) <- 15
mp

## Loading a small subset of direct injection, single spectrum files
library(msdata)
fticrf <- list.files(system.file("fticr-mzML", package = "msdata"),
                    recursive = TRUE, full.names = TRUE)
fticr <- readMSData(fticrf[1], msLevel. = 1, mode = "onDisk")

## Perform the MSW peak detection on these:
p <- MSWParam(scales = c(1, 7), peakThr = 80000, ampTh = 0.005,
             SNR.method = "data.mean", winSize.noise = 500)
fticr <- findChromPeaks(fticr, param = p)

head(chromPeaks(fticr))
}
\seealso{
The \code{\link{do_findPeaks_MSW}} core API function
    and \code{\link{findPeaks.MSW}} for the old user interface.

\code{\link{XCMSnExp}} for the object containing the results of
    the peak detection.

Other peak detection methods: 
\code{\link{findChromPeaks}()},
\code{\link{findChromPeaks-centWave}},
\code{\link{findChromPeaks-centWaveWithPredIsoROIs}},
\code{\link{findChromPeaks-massifquant}},
\code{\link{findChromPeaks-matchedFilter}}
}
\author{
Joachim Kutzera, Steffen Neumann, Johannes Rainer
}
\concept{peak detection methods}
