% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-Chromatogram.R,
%   R/methods-MChromatograms.R
\name{findChromPeaks,Chromatogram,CentWaveParam-method}
\alias{findChromPeaks,Chromatogram,CentWaveParam-method}
\alias{findChromPeaks,MChromatograms,CentWaveParam-method}
\alias{findChromPeaks-Chromatogram-CentWaveParam}
\alias{findChromPeaks,MChromatograms,MatchedFilterParam-method}
\title{centWave-based peak detection in purely chromatographic data}
\usage{
\S4method{findChromPeaks}{Chromatogram,CentWaveParam}(object, param, ...)

\S4method{findChromPeaks}{MChromatograms,CentWaveParam}(object, param, BPPARAM = bpparam(), ...)

\S4method{findChromPeaks}{MChromatograms,MatchedFilterParam}(object, param, BPPARAM = BPPARAM, ...)
}
\arguments{
\item{object}{a \link{Chromatogram} or \link{MChromatograms} object.}

\item{param}{a \link{CentWaveParam} object specifying the settings for the
peak detection. See \code{\link[=peaksWithCentWave]{peaksWithCentWave()}} for the description of
arguments used for peak detection.}

\item{...}{currently ignored.}

\item{BPPARAM}{a parameter class specifying if and how parallel processing
should be performed (only for \code{XChromatograms} objects). It defaults to
\code{bpparam()}. See \code{\link[BiocParallel:register]{BiocParallel::bpparam()}} for more information.}
}
\value{
If called on a \code{Chromatogram} object, the method returns an \link{XChromatogram}
object with the identified peaks. Columns \code{"mz"}, \code{"mzmin"} and \code{"mzmax"} in
the \code{chromPeaks()} peak matrix provide the mean m/z and the maximum and
minimum m/z value of the \code{Chromatogram} object. See \code{\link[=peaksWithCentWave]{peaksWithCentWave()}}
for details on the remaining columns.
}
\description{
\code{findChromPeaks} on a \link{Chromatogram} or \link{MChromatograms} object with a
\link{CentWaveParam} parameter object performs centWave-based peak detection
on purely chromatographic data. See \link{centWave} for details on the method
and \link{CentWaveParam} for details on the parameter class.
Note that not all settings from the \code{CentWaveParam} will be used.
See \code{\link[=peaksWithCentWave]{peaksWithCentWave()}} for the arguments used for peak detection
on purely chromatographic data.

After chromatographic peak detection, identified peaks can also be \emph{refined}
with the \code{\link[=refineChromPeaks]{refineChromPeaks()}} method, which can help to reduce peak
detection artifacts.
}
\examples{

library(MSnbase)
## Loading a test data set with identified chromatographic peaks
faahko_sub <- loadXcmsData("faahko_sub2")
faahko_sub <- filterRt(faahko_sub, c(2500, 3700))

##
od <- as(filterFile(faahko_sub, 1L), "MsExperiment")

## Extract chromatographic data for a small m/z range
chr <- chromatogram(od, mz = c(272.1, 272.3))[1, 1]

## Identify peaks with default settings
xchr <- findChromPeaks(chr, CentWaveParam())
xchr

## Plot data and identified peaks.
plot(xchr)

library(MsExperiment)
library(xcms)
## Perform peak detection on an MChromatograms object

fls <- c(system.file("cdf/KO/ko15.CDF", package = "faahKO"),
    system.file("cdf/KO/ko16.CDF", package = "faahKO"),
    system.file("cdf/KO/ko18.CDF", package = "faahKO"))
od3 <- readMsExperiment(fls)

## Disable parallel processing for this example
register(SerialParam())

## Extract chromatograms for a m/z - retention time slice
chrs <- chromatogram(od3, mz = 344, rt = c(2500, 3500))

## Perform peak detection using CentWave
xchrs <- findChromPeaks(chrs, param = CentWaveParam())
xchrs

## Extract the identified chromatographic peaks
chromPeaks(xchrs)

## plot the result
plot(xchrs)
}
\seealso{
\code{\link[=peaksWithCentWave]{peaksWithCentWave()}} for the downstream function and \link{centWave}
for details on the method.
}
\author{
Johannes Rainer
}
