% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataClasses.R, R/functions-Params.R,
%   R/functions-XCMSnExp.R, R/methods-XCMSnExp.R
\docType{class}
\name{CalibrantMassParam-class}
\alias{CalibrantMassParam-class}
\alias{mz,CalibrantMassParam}
\alias{CalibrantMassParam}
\alias{isCalibrated}
\alias{calibrate,XCMSnExp-method}
\title{Calibrant mass based calibration of chromatgraphic peaks}
\usage{
CalibrantMassParam(
  mz = list(),
  mzabs = 1e-04,
  mzppm = 5,
  neighbors = 3,
  method = "linear"
)

isCalibrated(object)

\S4method{calibrate}{XCMSnExp}(object, param)
}
\arguments{
\item{mz}{a \code{numeric} or \code{list} of \code{numeric} vectors with reference mz
values. If a \code{numeric} vector is provided, this is used for each sample
in the \code{XCMSnExp} object. If a \code{list} is provided, it's length has to be
equal to the number of samples in the experiment.}

\item{mzabs}{\code{numeric(1)} the absolute error/deviation for matching peaks to
calibrants (in Da).}

\item{mzppm}{\code{numeric(1)} the relative error for matching peaks to calibrants
in ppm (parts per million).}

\item{neighbors}{\code{integer(1)} with the maximal number of peaks within the
permitted distance to the calibrants that are considered. Among these the
mz value of the peak with the largest intensity is used in the
calibration function estimation.}

\item{method}{\code{character(1)} defining the method that should be used to
estimate the calibration function. Can be \code{"shift"}, \code{"linear"} (default)
or \code{"edgeshift"}.}

\item{object}{An \link{XCMSnExp} object.}

\item{param}{The \code{CalibrantMassParam} object with the calibration settings.}
}
\value{
For \code{CalibrantMassParam}: a \code{CalibrantMassParam} instance.
For \code{calibrate}: an \link{XCMSnExp} object with chromatographic peaks being
calibrated. \strong{Be aware} that the actual raw mz values are not (yet)
calibrated, but \strong{only} the identified chromatographic peaks.

The \code{CalibrantMassParam} function returns an instance of
the \code{CalibrantMassParam} class with all settings and properties set.

The \code{calibrate} method returns an \link{XCMSnExp} object with the
chromatographic peaks being calibrated. Note that \strong{only} the detected
peaks are calibrated, but not the individual mz values in each spectrum.
}
\description{
Calibrate peaks using mz values of known masses/calibrants.
mz values of identified peaks are adjusted based on peaks that are close
to the provided mz values. See details below for more information.

The \code{isCalibrated} function returns \code{TRUE} if chromatographic
peaks of the \link{XCMSnExp} object \code{x} were calibrated and \code{FALSE} otherwise.
}
\details{
The method does first identify peaks that are close to the provided
mz values and, given that there difference to the calibrants is smaller
than the user provided cut off (based on arguments \code{mzabs} and \code{mzppm}),
their mz values are replaced with the provided mz values. The mz values
of all other peaks are either globally shifted (for \code{method = "shift"}
or estimated by a linear model through all calibrants.
Peaks are considered close to a calibrant mz if the difference between
the calibrant and its mz is \verb{<= mzabs + mz * mzppm /1e6}.

\strong{Adjustment methods}: adjustment function/factor is estimated using
the difference between calibrant and peak mz values only for peaks
that are close enough to the calibrants. The availabel methods are:
\itemize{
\item \code{shift}: shifts the m/z of each peak by a global factor which
corresponds to the average difference between peak mz and calibrant mz.
\item \code{linear}: fits a linear model throught the differences between
calibrant and peak mz values and adjusts the mz values of all peaks
using this.
\item \code{edgeshift}: performs same adjustment as \code{linear} for peaks that are
within the mz range of the calibrants and shift outside of it.
}

For more information, details and examples refer to the
\emph{xcms-direct-injection} vignette.
}
\note{
\code{CalibrantMassParam} classes don't have exported getter or setter
methods.
}
\author{
Joachim Bargsten, Johannes Rainer
}
