% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-filterFeatures.R
\name{PercentMissingFilter}
\alias{PercentMissingFilter}
\alias{filterFeatures,XcmsResult,PercentMissingFilter-method}
\alias{filterFeatures,SummarizedExperiment,PercentMissingFilter-method}
\title{Filter features based on the percentage of missing data}
\usage{
PercentMissingFilter(threshold = 30, f = factor())

\S4method{filterFeatures}{XcmsResult,PercentMissingFilter}(object, filter, ...)

\S4method{filterFeatures}{SummarizedExperiment,PercentMissingFilter}(object, filter, assay = 1)
}
\arguments{
\item{threshold}{`numeric` percentage (between 0 and 100) of accepted missing
values for a feature in one sample group.}

\item{f}{`vector` of the same length as the `object`, specifying the sample
type for each sample in the dataset. The percentage of missing values per
feature will be computed within each of these sample groups. Parameter `f`,
if not already a `factor`, will be converted to one using the factor function.
Samples with an `NA` as their value in `f` will be excluded from calculation.}

\item{object}{\code{XcmsExperiment} or \code{SummarizedExperiment}. For an
\code{XcmsExperiment} object, the \code{featureValues(object)} will be evaluated, and
for \code{Summarizedesxperiment} the \code{assay(object, assay)}. The object will be
filtered.}

\item{filter}{The parameter object selecting and configuring the type of
filtering. It can be one of the following classes: \code{\link{RsdFilter}},
\code{\link{DratioFilter}}, \code{\link{PercentMissingFilter}} or \code{\link{BlankFlag}}.}

\item{...}{Optional parameters. For \code{object} being an \code{XcmsExperiment}:
parameters for the \code{\link[=featureValues]{featureValues()}} call.}

\item{assay}{For filtering of \code{SummarizedExperiment} objects only. Indicates
which assay the filtering will be based on. Note that the features for the
entire object will be removed, but the computations are performed on a single
assay. Default is 1, which means the first assay of the \code{object} will
be evaluated.}
}
\value{
For `PercentMissingFilter`: a `PercentMissingFilter` class.
`filterFeatures` return the input object minus the features that did not met
the user input threshold
}
\description{
The `PercentMissingFilter` class and method enable users to filter features
from an `XcmsExperiment` or `SummarizedExperiment` object based on the
percentage (values from 1 to 100) of missing values for each features in
different sample groups and filters them according to a provided threshold.

This `filter` is part of the possible dispatch of the generic function
`filterFeatures`. Features with a percentage of missing values *higher* (`>`)
than the user input threshold in all sample groups will be removed (i.e.
features for which the proportion of missing values is below (`<=`) the
threshold in at least one sample group will be retained).
}
\seealso{
Other Filter features in xcms: 
\code{\link{BlankFlag}},
\code{\link{DratioFilter}},
\code{\link{RsdFilter}}
}
\author{
Philippine Louail
}
\concept{Filter features in xcms}
