% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomposeVar.R
\name{decomposeVar}
\alias{decomposeVar}
\title{Decompose input contrasts to decoded and residual fractions}
\usage{
decomposeVar(
  M,
  MD = NULL,
  treatm = NULL,
  cntr = NULL,
  processInput = TRUE,
  organism = c("Human", "Mouse"),
  featureType = c("AUTO", "ENSEMBL_GENE_ID", "GENE_SYMBOL", "ENTREZ_GENE_ID",
    "ARCHS4_ID"),
  pseudocount = 4,
  verbose = TRUE
)
}
\arguments{
\item{M}{Matrix of raw gene counts.}

\item{MD}{Matrix of gene deltas (optional). If \code{MD} is specified,
\code{M} is assumed to be a raw gene count matrix specifying context for
contrasts specified in \code{MD}. \code{MD} is then a matrix of gene
deltas with the same dimensions as \code{M}. If \code{MD} is specified,
\code{treatm} and \code{cntr} have to be \code{NULL}.}

\item{treatm, cntr}{Vectors indicating column indices in \code{M}
corresponding to treatments and controls. If \code{treatm} and
\code{cntr} are specified, \code{MD} has to be \code{NULL}.}

\item{processInput}{If set to \code{TRUE} (default) the count matrix will
be preprocessed (library normalized, log2-transformed after addition of
a pseudocount, NA values will be set to 0).}

\item{organism}{Selects the autoencoder model trained on data from this
species. One of \code{"Human"} or \code{"Mouse"}.}

\item{featureType}{Set to \code{"AUTO"} for automatic feature id-type
detection. Alternatively specify the type of supplied id features.
Current supported types are \code{"ENSEMBL_GENE_ID"},
\code{"GENE_SYMBOL"}, \code{"ENTREZ_GENE_ID"} and \code{"ARCHS4_ID"}.}

\item{pseudocount}{Numerical scalar, added to raw counts in \code{M} when
\code{preprocessInput = TRUE}.}

\item{verbose}{Logical scalar indicating whether to print messages along
the way.}
}
\value{
A \code{\link[SummarizedExperiment]{SummarizedExperiment}} object
    with the decomposed contrasts in the assays and the decomposed variance
    as the \code{\link[SummarizedExperiment]{colData}}.
}
\description{
Decompose input contrasts (gene expression deltas) to decoded (generic)
and residual (unique) components according to a contrast encoder-decoder
pre-trained on a large corpus of public RNAseq experiments.
}
\details{
When calling \code{decomposeVar()}, you may see an \code{ImportError}
    on the console. This most likely does not have any negative consequences,
    rather it means that R and python may not be library compatible and that
    an automated fallback approach is being used (for more details see
    \code{testload} argument of \code{\link[basilisk]{basiliskStart}}).
}
\examples{
MKL1_human <- readRDS(system.file("extdata", "GSE215150_MKL1_Human.rds",
package = "orthos"))

# Specifying M, treatm and cntr:
dec_MKL1_human <- decomposeVar(M = MKL1_human, treatm = c(2, 3), cntr = c(1, 1), 
                              organism = "Human", verbose = FALSE)
                              
                              
# Alternatively by specifying M and MD:
pseudocount <- 4 
M  <- sweep(MKL1_human, 2,
            colSums(MKL1_human), FUN = "/") * 1e+06
M  <- log2(M + pseudocount)
DeltaM <- M[,c("MKL1","caMKL1")]-M[,"Ctrl"] # Matrix of contrasts
ContextM <- M[,c("Ctrl","Ctrl")] # Matrix with context for the specified contrasts
colnames(ContextM) <- colnames(DeltaM) # M and MD need identical dimnames                       
RES <- decomposeVar(M = ContextM, MD = DeltaM, processInput = FALSE)

}
\author{
Panagiotis Papasaikas
}
