% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggkegg.R
\name{rawValue}
\alias{rawValue}
\title{rawValue}
\usage{
rawValue(
  values,
  pid = NULL,
  column = "name",
  show_type = "gene",
  how = "any",
  white_background = TRUE,
  auto_add = FALSE,
  man_graph = NULL,
  sep = " ",
  remove_dot = TRUE
)
}
\arguments{
\item{values}{named vector, or list of them}

\item{pid}{pathway id}

\item{column}{name of column to match for}

\item{show_type}{type to be shown}

\item{how}{how to match the node IDs with the queries 'any' or 'all'}

\item{white_background}{fill background color white}

\item{auto_add}{automatically add prefix based on pathway prefix}

\item{man_graph}{provide manual tbl_graph}

\item{sep}{separater for name, default to " "}

\item{remove_dot}{remove "..." in the name
typically, "gene", "ortholog", or "compound"}
}
\value{
ggraph with overlaid KEGG map
}
\description{
given named vector of quantitative values,
return the ggplot object with raw KEGG map overlaid.
Colors can be changed afterwards.
}
\examples{
## Colorize by passing the named vector of numeric values
rv <- rawValue(c(1.1) |> setNames("hsa:6737"), 
        man_graph=create_test_pathway())
}
