% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parentCombinations.R
\name{parentCombinations}
\alias{parentCombinations}
\title{Create all combinations of cell type relationships from a list of parents}
\usage{
parentCombinations(all, ..., parentList = NULL)
}
\arguments{
\item{all}{A list of all the `to` cell types Kontextual is evaluated over.}

\item{...}{Vectors of each parent population.}

\item{parentList}{a named list where the names correspond to parent names and
the values contain a vector of children for that parent. Note: If parentList
is specified the `...` argument will be ignored, see examples.}
}
\value{
A data frame containing all pairwise cell relationships and their
corresponding parent
}
\description{
This function takes in named vectors of all the parent populations in the
dataset, and creates a data frame containing all pairwise cell relationships,
this data frame can be inputed into the `parentDf` argument in `Kontextual`.
}
\examples{
# Example 1, using `parentList`

parentList <- list(
  "tcells" = c("CD4", "CD8"),
  "tissue" = c("epithelial", "stromal")
)

allCells <- c("tumour", "CD4", "CD8", "epithelial", "stromal")

parentCombinations(all = allCells, parentList = parentList)


# Example 2, with `...` operator
tcells <- c("CD4", "CD8")
tissue <- c("epithelial", "stromal")
allCells <- c("tumour", tissue, tcells)

parentCombinations(all = allCells, tcells, tissue)

}
