% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_metadata.R
\name{update_fill_value}
\alias{update_fill_value}
\title{Convert special fill values from strings to numbers}
\usage{
update_fill_value(metadata)
}
\arguments{
\item{metadata}{A list containing the array metadata.  This should normally
be generated by running \code{read_json()} on the \code{.zarray} file.}
}
\value{
Returns a list with the same structure as the input.  The returned
list will be identical to the input, unless the \code{fill_value} entry was on
of: NULL, "NaN", "Infinity" or "-Infinity".
}
\description{
Special case fill values (NaN, Inf, -Inf) are encoded as strings in the Zarr
metadata.  R will create arrays of type character if these are defined and
the chunk isn't present on disk. This function updates the fill value to be
R's representation of these special values, so numeric arrays are created. A
"null" fill value implies no missing values. We set this to NA as you can't
create an array of type NULL in R. It should have no impact if there are
really no missing values.
}
\keyword{Internal}
