% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-mp_cal_pcoa.R
\name{mp_cal_nmds}
\alias{mp_cal_nmds}
\alias{mp_cal_nmds,MPSE-method}
\alias{mp_cal_nmds,MPSE}
\alias{mp_cal_nmds,tbl_mpse-method}
\alias{mp_cal_nmds,tbl_mpse}
\alias{mp_cal_nmds,grouped_df_mpse-method}
\alias{mp_cal_nmds,grouped_df_mpse}
\title{Nonmetric Multidimensional Scaling Analysis with MPSE or tbl_mpse object}
\usage{
mp_cal_nmds(
  .data,
  .abundance,
  distmethod = "bray",
  .dim = 2,
  action = "add",
  seed = 123,
  ...
)

\S4method{mp_cal_nmds}{MPSE}(
  .data,
  .abundance,
  distmethod = "bray",
  .dim = 2,
  action = "add",
  seed = 123,
  ...
)

\S4method{mp_cal_nmds}{tbl_mpse}(
  .data,
  .abundance,
  distmethod = "bray",
  .dim = 2,
  action = "add",
  seed = 123,
  ...
)

\S4method{mp_cal_nmds}{grouped_df_mpse}(
  .data,
  .abundance,
  distmethod = "bray",
  .dim = 2,
  action = "add",
  seed = 123,
  ...
)
}
\arguments{
\item{.data}{MPSE or tbl_mpse object}

\item{.abundance}{the name of abundance to be calculated.}

\item{distmethod}{character the method to calculate distance.}

\item{.dim}{integer The number of dimensions to be returned, default is 2.}

\item{action}{character "add" joins the NMDS result to the object, "only" return
a non-redundant tibble with the NMDS result. "get" return 'metaMDS' object can
be analyzed with related 'vegan' function.}

\item{seed}{a random seed to make this analysis reproducible, default is 123.}

\item{...}{additional parameters see also 'mp_cal_dist'.}
}
\value{
update object or tbl according to the action.
}
\description{
Nonmetric Multidimensional Scaling Analysis with MPSE or tbl_mpse object
}
\examples{
data(mouse.time.mpse)
mpse <- mouse.time.mpse \%>\%
        mp_decostand(.abundance=Abundance) \%>\%
        mp_cal_nmds(.abundance=hellinger, distmethod="bray", action="add")
library(ggplot2)
p <- mpse \%>\% mp_plot_ord(.ord=nmds, 
                          .group=time, 
                          .color=time, 
                          .alpha=0.8, 
                          ellipse=TRUE, 
                          show.sample=TRUE)
p <- p +
     scale_fill_manual(values=c("#00AED7", "#009E73")) + 
     scale_color_manual(values=c("#00AED7", "#009E73"))
\dontrun{
mouse.time.mpse \%>\%
  mp_decostand(.abundance=Abundance) \%>\%
  mp_cal_nmds(.abundance=hellinger, distmethod="bray", .dim=2, action="only") -> tbl
tbl
x <- names(tbl)[grepl("NMDS1", names(tbl))] \%>\% as.symbol()
y <- names(tbl)[grepl("NMDS2", names(tbl))] \%>\% as.symbol()
library(ggplot2)
tbl \%>\%
 ggplot(aes(x=!!x, y=!!y, color=time)) +
 geom_point() +
 geom_vline(xintercept=0, color="grey20", linetype=2) +
 geom_hline(yintercept=0, color="grey20", linetype=2) +
 theme_bw() +
 theme(panel.grid=element_blank())
}
}
\author{
Shuangbin Xu
}
