% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{exampleHiCDOCDataSetProcessed}
\alias{exampleHiCDOCDataSetProcessed}
\title{Example HiCDOCDataSet, filtered, normalized and with compartements detected.}
\format{
S4 HiCDOCDataSet object with the following characteristics:
\describe{
  \item{chromosomes}{4 chromosomes: X, Y, Z}
  \item{conditions}{3 conditions: 1, 2, 3}
  \item{replicates}{3 replicates: R1, R2, R3}
  \item{binSize}{A resolution of 137 bases}
}
}
\usage{
data(exampleHiCDOCDataSetProcessed)
}
\value{
A \code{\link{HiCDOCDataSet}}, already filtered and normalized.
}
\description{
A S4 HiCDOCDataSet object with 3 chromosomes, 3 conditions and 3 replicates.
Can be retrieved by running :
\code{data(exampleHiCDOCDataSet); 
set.seed(123); 
exampleHiCDOCDataSetProcessed <- HiCDOC(exampleHiCDOCDataSet)}
}
\examples{
data(exampleHiCDOCDataSetProcessed)
exampleHiCDOCDataSetProcessed
}
\keyword{datasets}
