% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\name{HiCDOCDataSetFromCool}
\alias{HiCDOCDataSetFromCool}
\title{\code{\link{HiCDOCDataSet}} constructor from Cool files.}
\usage{
HiCDOCDataSetFromCool(paths, replicates, conditions, binSize = NA)
}
\arguments{
\item{paths}{A vector of paths to \code{.cool} or \code{.mcool} files.}

\item{replicates}{A vector of replicate names repeated along the conditions.}

\item{conditions}{A vector of condition names repeated along the replicates.}

\item{binSize}{The resolution (span of each position in number of bases). Optionally
provided to select the appropriate resolution in \code{.mcool} files.
Defaults to NULL.}
}
\value{
A \code{\link{HiCDOCDataSet}}.
}
\description{
Constructs a \code{\link{HiCDOCDataSet}} from a set of \code{.cool} or
\code{.mcool} files.
}
\examples{
\dontrun{
    # Path to each file
    paths = c(
      'path/to/condition-1.replicate-1.cool',
      'path/to/condition-1.replicate-2.cool',
      'path/to/condition-2.replicate-1.cool',
      'path/to/condition-2.replicate-2.cool',
      'path/to/condition-3.replicate-1.cool'
    )

    # Replicate and condition of each file. Can be names instead of numbers.
    replicates <- c(1, 2, 1, 2, 1)
    conditions <- c(1, 1, 2, 2, 3)

    # Resolution to select in .mcool files
    binSize = 500000

    # Instantiation of data set
    object <- HiCDOCDataSetFromCool(
      paths,
      replicates = replicates,
      conditions = conditions,
      binSize = binSize # Specified for .mcool files.
    )
}

}
