% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeSpillmat.R
\name{computeSpillmat}
\alias{computeSpillmat}
\title{Compute spillover matrix}
\usage{
computeSpillmat(
  x,
  assay = "counts",
  interactions = c("default", "all"),
  method = c("default", "classic"),
  trim = 0.5,
  th = 1e-05
)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}

\item{assay}{character string specifying which assay to use; should be one
of \code{assayNames(x)} and correspond to count-like data, as linearity 
assumptions underlying spillover estimation won't hold otherwise.}

\item{interactions}{\code{"default"} or \code{"all"}. Specifies which interactions spillover
should be estimated for. The default exclusively takes into consideration
interactions that are sensible from a chemical and physical point of view
(see below for more details).}

\item{method}{\code{"default"} or \code{"classic"}. Specifies the function
to be used for spillover estimation (see below for details).}

\item{trim}{numeric. Specifies the trim value used for estimation of spill values.
Note that \code{trim = 0.5} is equivalent to using medians.}

\item{th}{single non-negative numeric. Specifies the threshold value
below which spill estimates will be set to 0.}
}
\value{
Returns a square compensation matrix with dimensions and dimension names
matching those of the input flowFrame. Spillover is assumed to be linear,
and, on the basis of their additive nature, spillover values are computed
independently for each interacting pair of channels.
}
\description{
Computes a spillover matrix from 
priorly identified single-positive populations.
}
\details{
The \code{default} method estimates the spillover as the median ratio
between the unstained spillover receiving and the stained spillover
emitting channel in the corresponding single stained populations.

\code{method = "classic"} will compute the slope of a line through
the medians (or trimmed means) of stained and unstained populations.
The medians (or trimmed means) computed from events that are i) negative
in the respective channels; and, ii) not assigned to interacting channels;
and, iii) not unassigned are subtracted as to account for background.

\code{interactions="default"} considers only expected interactions, that is,
M+/-1 (detection sensitivity), M+16 (oxide formation) and channels measuring
metals that are potentially contaminated by isotopic impurites
(see reference below and \code{\link{isotope_list}}).

\code{interaction="all"} will estimate spill for all n x n - n
interactions, where n denotes the number of single-color controls
(= \code{nrow(bc_key(re))}).
}
\examples{
# construct SCE from single-stained control samples
data(ss_exp)
sce <- prepData(ss_exp)

# specify mass channels stained for
bc_ms <- c(139, 141:156, 158:176)

# debarcode single-positive populations
sce <- assignPrelim(sce, bc_ms)
sce <- estCutoffs(sce)
sce <- applyCutoffs(sce)

# estimate & extract spillover matrix 
sce <- computeSpillmat(sce)

library(SingleCellExperiment)
head(metadata(sce)$spillover_matrix)

}
\references{
Coursey, J.S., Schwab, D.J., Tsai, J.J., Dragoset, R.A. (2015).
Atomic weights and isotopic compositions,
(available at http://physics.nist.gov/Comp).
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
