% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{spatialPlot}
\alias{spatialPlot}
\title{L-R interaction score spatial display}
\usage{
spatialPlot(
  v,
  areas,
  inter.name,
  rev.y = TRUE,
  ref.plot = FALSE,
  ref.plot.only = FALSE,
  image.raster = NULL,
  x.col = "array_col",
  y.col = "array_row",
  label.col = "label",
  idSpatial.col = "idSpatial",
  cut.p = 0.01,
  low.color = "royalblue3",
  mid.color = "white",
  high.color = "orange",
  title.fs = 12,
  legend.fs = 10,
  axis.fs = 10,
  label.fs = 12,
  dot.size = 0.5,
  legend.dot.factor = 10,
  ref.colors = NULL
)
}
\arguments{
\item{v}{A named vector containing the scores, names must be
the IDs of each location.}

\item{areas}{A data.frame containing at least the x and y
coordinates of the locations as well as the unique IDs of spatial locations.
In case \code{ref.plot} is set to TRUE,
a label column is required additionally.}

\item{inter.name}{Interaction name to display as plot title.}

\item{rev.y}{A Boolean indicating whether low y coordinates should be
at the top of the plot.}

\item{ref.plot}{A Boolean indicating whether a reference map of the tissue
with area labels should be plot aside.}

\item{ref.plot.only}{A Boolean indicating that only the reference plot
should be output.}

\item{image.raster}{Raster object image to plot raw tissue image as
reference.}

\item{x.col}{Column name in \code{areas} containing x coordinates.}

\item{y.col}{Column name in \code{areas} containing y coordinates.}

\item{label.col}{Column name in \code{areas} containing area labels.}

\item{idSpatial.col}{Column name in \code{areas} containing the unique
IDs of spatial locations.}

\item{cut.p}{Proportion of top and bottom values for thresholding.}

\item{low.color}{Color for low score values.}

\item{mid.color}{Color for score = 0.}

\item{high.color}{Color for high score values.}

\item{title.fs}{Title font size.}

\item{legend.fs}{Legend items font size.}

\item{axis.fs}{Axis ticks font size.}

\item{label.fs}{Legend titles and axis names font size.}

\item{dot.size}{Dot size.}

\item{legend.dot.factor}{A factor applied to obtain the legend dot size.}

\item{ref.colors}{A vector of colors to bypass those automatically chosen
by ggplot2 for the tissue areas in the reference plot.}
}
\value{
A spatial plot
}
\description{
Generate a plot with scores at the spatial coordinates of the corresponding
sample locations. Not limited to BulkSignalR gene signature scores.
}
\details{
A single (scores) or side-by-side (reference tissue & scores) plot
is generated.
}
\examples{
data(bsrinf.spa, package = "BulkSignalR")
data(bsrdm.spa, package = "BulkSignalR")
data(annotation.spa, package = "BulkSignalR")

thres <- 0.01
bsrinf.red <- reduceToBestPathway(bsrinf.spa)
s.red  <- BSRSignature(bsrinf.red, qval.thres=thres)
scores.red <- scoreLRGeneSignatures(bsrdm.spa,s.red)

inter <- "{SLIT2} / {GPC1}"

spatialPlot(scores.red[inter, ], annotation.spa, inter,
   ref.plot = TRUE, ref.plot.only = FALSE,
   image.raster = NULL, dot.size = 1,
   label.col = "ground_truth")

}
