% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellTypeAssign.R
\name{cellTypeFrequency}
\alias{cellTypeFrequency}
\title{Cell type frequencies in relations to gene sets}
\usage{
cellTypeFrequency(rel, lr, min.n.genes = 1)
}
\arguments{
\item{rel}{The data.frame output by
\code{"\link[=BSRInference-class]{relateToGeneSet}"}.}

\item{lr}{The data.frame output by
\code{"\link{assignCellTypesToInteractions}"}.}

\item{min.n.genes}{Minimum number of genes in the gene set for
one (L,R,pathway) triple.}
}
\value{
A list of two slots: t for counting how many times each cell type
is involved; s for summing the weights of each involved cell type.
}
\description{
Count how many times and with which weights cell types were involved
in the (L,R,pathway) triples that targeted genes in a gene set.
}
\examples{
data(bsrdm, package = "BulkSignalR")
data(bsrinf, package = "BulkSignalR")
data(immune.signatures, package = "BulkSignalR")
data(tme.signatures, package = "BulkSignalR")
data(p.EMT, package = "BulkSignalR")

immune.signatures <- immune.signatures[immune.signatures$signature \%in\%
    c("T cells"), ]

signatures <- rbind(immune.signatures, tme.signatures[
    tme.signatures$signature \%in\% c("Fibroblasts"),
])

tme.scores <- scoreSignatures(bsrdm, signatures)

# assignment
lr2ct <- assignCellTypesToInteractions(bsrdm, bsrinf, tme.scores)

# relate to p-EMT (should be done in HNSCC normally, not in SDC)
p.EMT <- p.EMT$gene
triggers <- relateToGeneSet(bsrinf, p.EMT)

# counts
cf <- cellTypeFrequency(triggers, lr2ct)
}
