% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{bubblePlotPathwaysLR}
\alias{bubblePlotPathwaysLR}
\title{Bubble Plot to explore LR & Pathways}
\usage{
bubblePlotPathwaysLR(
  bsrinf,
  pathways,
  qval.thres = 1,
  filter.L = NULL,
  filter.R = NULL,
  color = "#16a647",
  pointsize = 6
)
}
\arguments{
\item{bsrinf}{BulkSignalR inference object.}

\item{pathways}{Vector of pathway names to keep.}

\item{qval.thres}{Maximum Q-value.}

\item{filter.L}{Vector of ligands to keep.}

\item{filter.R}{Vector of receptors to keep.}

\item{color}{Main color used for the gradient.}

\item{pointsize}{Global point size.}
}
\value{
A bubble plot displayed in the current viewport.

This is a convenience function to propose a simple way
of representing LR - Pathways association
with their respective correlation
and Q-values.
}
\description{
Quick check to observe LR - Pathways association
with their respective correlation
and Q-values.
}
\examples{
data(bsrinf, package = "BulkSignalR")
pathways <- LRinter(bsrinf)[1,c("pw.name")]
bubblePlotPathwaysLR(bsrinf,
pathways = pathways,
qval.thres = 0.1,
color = "red",
pointsize = 8
)
}
