% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSRInferenceComp-class.R
\docType{class}
\name{BSRInferenceComp-class}
\alias{BSRInferenceComp-class}
\title{BulkSignalR cluster comparison-based inference object}
\description{
An S4 class to represent ligand-receptor interactions inferred from
a comparison between two clusters of samples. This class inherits from
BSRInference.
}
\details{
This class is contains inferred LR interactions along with
their statistical significance. Data representation supports subsequent
reductions to pathways, etc. See reduction functions
\code{"\link[=BSRInferenceComp-class]{reduceToBestPathway}"},
\code{"\link[=BSRInferenceComp-class]{reduceToLigand}"},
\code{"\link[=BSRInferenceComp-class]{reduceToReceptor}"} and
\code{"\link[=BSRInferenceComp-class]{reduceToPathway}"}.
}
\section{Slots}{

\describe{
\item{\code{cmp.name}}{The name of the BSRClusterComp object in a BSRDataModelComp
object comp list.}

\item{\code{src.cmp.name}}{The name of an optional BSRClusterComp object in a
BSRDataModelComp object comp list in case paracrine inferences were
performed.}

\item{\code{tg.pval}}{A list of target gene P-values, one
entry per interaction}

\item{\code{tg.logFC}}{A list of target gene logFC, one
entry per interaction}

\item{\code{tg.expr}}{A list of target gene expression, one
entry per interaction}
}}

\examples{
new("BSRInferenceComp")
}
