## ----setup, include = FALSE---------------------------------------------------
knitr::knit_hooks$set(optipng = knitr::hook_optipng)

## ----load-libs, message = FALSE,  warning = FALSE, results = FALSE------------
library(BulkSignalR)

## ----cash,eval=FALSE----------------------------------------------------------
# 
# # You can see hidden environment variable list as follows.
# ls(BulkSignalR:::.SignalR)
# 
# # Setup Pathways for reactome (can be done for GO-BP also)
# 
# subset <- c("REACTOME_BASIGIN_INTERACTIONS",
# "REACTOME_SYNDECAN_INTERACTIONS",
# "REACTOME_ECM_PROTEOGLYCANS",
# "REACTOME_CELL_JUNCTION_ORGANIZATION")
# 
# reactSubset <- BulkSignalR:::.SignalR$BulkSignalR_Reactome[
# BulkSignalR:::.SignalR$BulkSignalR_Reactome$`Reactome name` %in% subset,]
# 
# resetPathways(dataframe = reactSubset,
# resourceName = "Reactome")
# 
# cacheInfo()
# cacheVersion()
# 
# cacheClear()
# 
# # Ask to download again
# createResources(onRequest=TRUE)
# 
# 
# # Set up LRdb
# df <- data.frame(
#   ligand    = c("A2M", "AANAT", "AANAT", "ACE", "ACE"),
#   receptor  = c("LRP1", "MTNR1A", "MTNR1B", "AGTR2", "BDKRB2")
# )
# resetLRdb(df,switch=TRUE)
# 
# # Set up Network
# df <- data.frame(
#   a.gn   = c("A2M", "AANAT", "AANAT", "ACE", "ACE"),
#   type  = c("regulates-transcription-of",
#    "regulates-transcription-of",
#    "regulates-transcription-of",
#    "regulates-transcription-of",
#    "regulates-transcription-of"),
#   b.gn  = c("LRP1", "MTNR1A", "MTNR1B", "AGTR2", "BDKRB2")
# )
# 
# resetNetwork(df)
# 
# 

## ----session-info-------------------------------------------------------------
sessionInfo()

