## ----setup, include = FALSE---------------------------------------------------
knitr::knit_hooks$set(optipng = knitr::hook_optipng)
options(rmarkdown.html_vignette.check_title = FALSE)

## ----load-libs, message = FALSE,  warning = FALSE, results = FALSE------------
library(BulkSignalR)

## ----diffmode1,eval=TRUE------------------------------------------------------
data(sdc, package = "BulkSignalR")
normal <- grep("^N", names(sdc))
bsrdm.comp <- BSRDataModelComp(sdc[, -normal])

## ----diffmode2,eval=TRUE------------------------------------------------------
colA <- as.integer(1:3)
colB <- as.integer(12:15)

n <- nrow(ncounts(bsrdm.comp))
stats <- data.frame(pval = runif(n),
logFC = rnorm(n, 0, 2),
expr = runif(n, 0, 10))
rownames(stats) <- rownames(ncounts(bsrdm.comp))

## ----diffmode3,eval=TRUE------------------------------------------------------

bsrcc <- BSRClusterComp(bsrdm.comp, colA, colB, stats)
bsrdm.comp <- addClusterComp(bsrdm.comp, bsrcc, "random.example")


## ----diffmode4,eval=TRUE------------------------------------------------------

subset <- c("REACTOME_BASIGIN_INTERACTIONS",
"REACTOME_SYNDECAN_INTERACTIONS",
"REACTOME_ECM_PROTEOGLYCANS",
"REACTOME_CELL_JUNCTION_ORGANIZATION")

reactSubset <- BulkSignalR:::.SignalR$BulkSignalR_Reactome[
BulkSignalR:::.SignalR$BulkSignalR_Reactome$`Reactome name` %in% subset,]

resetPathways(dataframe = reactSubset,
resourceName = "Reactome")

bsrinf.comp <- BSRInferenceComp(bsrdm.comp,
reference="REACTOME",
max.pval = 1, 
"random.example")

head(LRinter(bsrinf.comp))


## ----session-info-------------------------------------------------------------
sessionInfo()

