% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KotliarovPBMCData.R
\name{KotliarovPBMCData}
\alias{KotliarovPBMCData}
\title{Obtain the Kotliarov CITE-seq data}
\usage{
KotliarovPBMCData(
  mode = c("rna", "adt"),
  ensembl = FALSE,
  location = TRUE,
  legacy = FALSE
)
}
\arguments{
\item{mode}{Character vector specifying whether to return either or both the RNA and ADT counts.}

\item{ensembl}{Logical scalar indicating whether the output row names should contain Ensembl identifiers.}

\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}

\item{legacy}{Logical scalar indicating whether to pull data from ExperimentHub.
By default, we use data from the gypsum backend.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object with a single matrix of UMI counts corresponding to the first \code{mode},
with an optional alternative Experiment if there is a second \code{mode}.
}
\description{
Obtain the Kotliarov PBMC CITE-seq data from Kotliarov et al. (2020).
}
\details{
This dataset contains 20 samples from 2 experimental batches, where each batch contains 5 high and 5 low responders. 
The 10 samples per batch were mixed and distributed across the 6 lanes using a cell hashing approach.

The column metadata contains the following fields:
\itemize{
\item \code{sample*}: identifiers for the sample of origin for each cell.
\item \code{adjmfc.time}: type of responder for each sample.
\item \code{tenx_lane}: 10X lane from which each cell was collected.
\item \code{batch}: the batch of origin.
\item \code{barcode_check}: barcode identifier.
\item \code{hash_*} and \code{hto_*} columns: \pkg{HTOdemux} outputs.
\item \code{DEMUXLET.*} columns: \pkg{demuxlet} outputs.
\item \code{joint_classification_global}: \pkg{HTOdemux} and \pkg{demuxlet} joint classification.
\item \code{nGene}: number of genes as defined from \pkg{Seurat}'s \code{CreateSeuratObject}.
\item \code{nUMI}: number of UMIs as defined from \pkg{Seurat}'s \code{CreateSeuratObject}.
\item \code{pctMT}: percent of mitochondrial reads as defined from \pkg{Seurat}'s \code{CreateSeuratObject}.
}
Note, no filtering has been performed based on the quality control metrics.

If \code{ensembl=TRUE}, the gene symbols in the RNA data are converted to Ensembl IDs in the row names of the output object.
Rows with missing Ensembl IDs are discarded, and only the first occurrence of duplicated IDs is retained.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link[SummarizedExperiment]{rowRanges}} for the RNA data.
Note that this is only performed if \code{ensembl=TRUE}.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/kotliarov-pbmc}.
}
\examples{
sce <- KotliarovPBMCData()

}
\references{
Kotliarov et al. (2020).
Broad immune activation underlies shared set point signatures for vaccine responsiveness in healthy individuals and disease activity in patients with lupus.
\emph{Nat. Med.} 26, 618–629
}
\author{
Stephany Orjuela,
with modifications from Aaron Lun
}
