\name{org.Sc.sgdCOMMON2ORF}
\alias{org.Sc.sgdCOMMON2ORF}
\title{Map Between Yeast Common Names and ORF Identifiers}
\description{
  org.Sc.sgdCOMMON2ORF is an R object that maps
  the yeast common names (gene names and aliases) to the
  corresponding yeast ORF identifiers.
}
\details{
  Each yeast common name, either gene name or alias, maps to
  a vector of ORF identifiers.  This mapping is the reverse
  mappings of org.Sc.sgdGENENAME.  
  
  Mappings were based on data provided by:

  Yeast Genome  
  http://sgd-archive.yeastgenome.org  
  With a date stamp from the source of: 2025-Sep23
}

\seealso{
  \itemize{
    \item \code{\link[AnnotationDbi]{AnnotationDb-class}} for use of
          the \code{select()} interface.
  }
}

\examples{
## select() interface:
## Objects in this package can be accessed using the select() interface
## from the AnnotationDbi package. See ?select for details.

## Bimap interface:
# Convert to a list
xx <- as.list(org.Sc.sgdCOMMON2ORF)
# Remove probes that do not map in COMMON2ORF
xx <- xx[!is.na(xx)]
if(length(xx) > 0){
    # Gets the ORF identifiers for the first five gene names/alias
    xx[1:5]
    # Get the first one
    xx[[1]]
}
}
\keyword{datasets}

