\name{org.At.tairPMID2TAIR}
\alias{org.At.tairPMID2TAIR}
\title{Map between PubMed Identifiers and TAIR Identifiers}
\description{
  org.At.tairPMID2TAIR is an R object that provides mappings between
  PubMed identifiers and TAIR identifiers.
}
\details{
  Each PubMed identifier is mapped to a named vector of TAIR
  identifiers. The name represents the PubMed identifier and the vector
  contains all TAIR identifiers that are represented by that PubMed
  identifier. The length of the vector may be one or longer, depending
  on how many TAIR identifiers are mapped to a given PubMed identifier.

  Titles, abstracts, and possibly full texts of articles can be obtained
  from PubMed by providing a valid PubMed identifier. The pubmed function of
  annotate can also be used for the same purpose
  
  Mappings were based on data provided by: Tair  
  https://www.arabidopsis.org/api/download-files/download?filePath=Public\_Data\_Releases/TAIR\_Data\_20230630/Locus\_Published\_20230630.txt.gz  
  With a date stamp from the source of: 2025-09-24
  
}

\seealso{
  \itemize{
    \item \code{\link[AnnotationDbi]{AnnotationDb-class}} for use of
          the \code{select()} interface.
  }
}

\examples{
## select() interface:
## Objects in this package can be accessed using the select() interface
## from the AnnotationDbi package. See ?select for details.

## Bimap interface:
# Convert the object to a list
xx <- as.list(org.At.tairPMID2TAIR)
if(length(xx) > 0){
    # The tair identifiers for the first two elements of XX
    xx[1:2]
    # Get the first one
    xx[[1]]
    if(interactive() && require(annotate)){
        # Gets article information as XML files for a PubMed id
        xmls <- pubmed(names(xx)[1], disp = "data")
        # Views article information using a browser
        pubmed(names(xx)[1], disp = "browser")
    }
}
}

\keyword{datasets}

