% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_fiji_inputs.R
\name{rescale_fiji_inputs}
\alias{rescale_fiji_inputs}
\title{Write same-scale hires images for input to Fiji}
\usage{
rescale_fiji_inputs(sample_info, out_dir)
}
\arguments{
\item{sample_info}{A \code{data.frame()} with columns \code{capture_area},
\code{group}, \code{fiji_xml_path}, \code{fiji_image_path},
\code{spaceranger_dir}, \code{intra_group_scalar}, and
\code{group_hires_scalef}. The last two are made by \code{rescale_fiji_inputs()}.}

\item{out_dir}{A \code{character(1)} vector giving a path to a directory to
place the output images, which must exist in advance.}
}
\value{
A \link[dplyr:reexports]{tibble}: a copy of \code{sample_info} with
additional columns
\code{intra_group_scalar} and \code{group_hires_scalef}.
}
\description{
Given a \code{data.frame()} of sample information (\code{sample_info})
with
columns \code{capture_area}, \code{group}, and \code{spaceranger_dir},
Write new high-resolution images for use as input to Fiji
\url{https://imagej.net/software/fiji/}. Particularly
when capture areas come from different slides, there is a risk of significant
scale differences among SpaceRanger's \code{tissue_hires_image.png} images;
that is, the physical distance represented by a pixel from each capture area
may differ nontrivially, leading to a distance-distorted output image, and
inconsistent scaling when later transforming pixel coordinates. This function
writes approximately high-res images whose pixels are of equal physical size
within each \code{group}, then adds \code{intra_group_scalar} and
\code{group_hires_scalef} columns to \code{sample_info}. \code{intra_group_scalar}
gives the scalar by a which a given capture area's
\code{tissue_hires_image.png} image and pixel
coordinates must be multiplied to match the scale of other \code{group}
members; \code{group_hires_scalef} gives the new \code{tissue_hires_scalef}
(as from SpaceRanger's \code{scalefactors_json.json} file) appropriate for
every capture area from the group.
}
\examples{
#    Define sample information for the example human brain data
sample_info <- dplyr::tibble(
    group = "Br2719",
    capture_area = c("V13B23-283_A1", "V13B23-283_C1", "V13B23-283_D1")
)
#   Add 'spaceranger_dir' column
sr_dir <- tempdir()
temp <- unzip(
    spatialLIBD::fetch_data("visiumStitched_brain_spaceranger"),
    exdir = sr_dir
)
sample_info$spaceranger_dir <- file.path(
    sr_dir, sample_info$capture_area, "outs", "spatial"
)

#   Add Fiji-output-related columns
fiji_dir <- tempdir()
temp <- unzip(
    spatialLIBD::fetch_data("visiumStitched_brain_Fiji_out"),
    exdir = fiji_dir
)
sample_info$fiji_xml_path <- temp[grep("xml$", temp)]
sample_info$fiji_image_path <- temp[grep("png$", temp)]

## Re-size images and add more information to the sample_info
out_dir <- tempdir()
sample_info_new <- rescale_fiji_inputs(sample_info, out_dir = out_dir)

#    Scale factors are computed that are necessary downstream (i.e. with
#    prep_fiji_*() functions)
sample_info_new[, setdiff(colnames(sample_info_new), colnames(sample_info))]

#    Image are produced that are ready for alignment in Fiji
list.files(out_dir)
}
\author{
Nicholas J. Eagles
}
