% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_motifs.R
\name{shuffle_motifs}
\alias{shuffle_motifs}
\title{Shuffle motifs by column.}
\usage{
shuffle_motifs(motifs, k = 2, method = "linear")
}
\arguments{
\item{motifs}{See \code{\link[=convert_motifs]{convert_motifs()}} for acceptable formats.}

\item{k}{\code{numeric(1)} K-let size.}

\item{method}{\code{character(1)} Currently only 'linear' is accepted.}
}
\value{
Motifs. See \code{\link[=convert_motifs]{convert_motifs()}} for available output
formats.
}
\description{
Given a set of motifs, shuffle the columns to create new motifs. Currently does not
support keeping the 'multifreq' slot. Only the 'bkg', 'nsites', 'strand',
and 'bkgsites' slots will be preserved. Uses the same shuffling methods
as \code{\link[=shuffle_sequences]{shuffle_sequences()}}. When shuffling more than one motif, all motif
columns are merged into a single pool and shuffled together, finally returning
them as motifs of identical lengths as the input motifs.
To instead shuffle motifs individually, call \code{\link[=shuffle_motifs]{shuffle_motifs()}}
using \code{lapply()}.
}
\seealso{
\code{\link[=shuffle_sequences]{shuffle_sequences()}}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
