% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_transfac.R
\name{read_transfac}
\alias{read_transfac}
\title{Import TRANSFAC motifs.}
\usage{
read_transfac(file, skip = 0)
}
\arguments{
\item{file}{\code{character(1)} File name.}

\item{skip}{\code{numeric(1)} If not zero, will skip however many desired lines in the
file before starting to read.}
}
\value{
\code{list} \linkS4class{universalmotif} objects.
}
\description{
Import TRANSFAC formatted motifs. Assumed to be DNA motifs, type PCM.
See \code{system.file("extdata", "transfac.txt", pacakge="universalmotif")}
for an example motif.
}
\details{
A few TRANSFAC tags are recognized, including AC, ID, NA, HC and OS.
HC will be set to the family slot and OS to the organism slot.
If AC, ID and NA are present, then AC will be set as the motif name
and NA as the alternate name. If AC is absent, then ID is set as the
name. If ID is also absent, then NA is set as the motif name.
}
\examples{
transfac <- read_transfac(system.file("extdata", "transfac.txt",
                                      package = "universalmotif"))

}
\references{
Wingender E, Dietze P, Karas H, Knuppel R (1996). “TRANSFAC: A
Database on Transcription Factors and Their DNA Binding Sites.”
\emph{Nucleic Acids Research}, \strong{24}, 238-241.
}
\seealso{
Other read_motifs: 
\code{\link{read_cisbp}()},
\code{\link{read_homer}()},
\code{\link{read_jaspar}()},
\code{\link{read_matrix}()},
\code{\link{read_meme}()},
\code{\link{read_motifs}()},
\code{\link{read_uniprobe}()}
}
\author{
Benjamin Jean-Marie Tremblay, \email{benjamin.tremblay@uwaterloo.ca}
}
\concept{read_motifs}
