% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_ppm}
\alias{get_ppm}
\title{Get Position Probability Matrix (PPM) from motif object}
\usage{
get_ppm(motif)
}
\arguments{
\item{motif}{object of class \code{RBPMotif}}
}
\value{
The position probability matrix of the specified motif
}
\description{
Return the position probability matrix of the specified motif.
}
\examples{
get_ppm(get_motif_by_id("M178_0.6")[[1]])
}
\seealso{
Other motif functions: 
\code{\link{generate_iupac_by_kmers}()},
\code{\link{generate_iupac_by_matrix}()},
\code{\link{generate_kmers_from_iupac}()},
\code{\link{get_motif_by_id}()},
\code{\link{get_motif_by_rbp}()},
\code{\link{get_motifs}()},
\code{\link{get_motifs_meta_info}()},
\code{\link{init_iupac_lookup_table}()},
\code{\link{set_motifs}()}
}
\concept{motif functions}
