% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyr_methods.R
\name{unite}
\alias{unite}
\alias{unite.SummarizedExperiment}
\title{Unite multiple columns into one by pasting strings together}
\usage{
\method{unite}{SummarizedExperiment}(data, col, ..., sep = "_", remove = TRUE, na.rm = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{col}{The name of the new column, as a string or symbol.

This argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote strings
and symbols). The name is captured from the expression with
\code{\link[rlang:defusing-advanced]{rlang::ensym()}} (note that this kind of interface where
symbols do not represent actual objects is now discouraged in the
tidyverse; we support it here for backward compatibility).}

\item{...}{<\code{\link[tidyr:tidyr_tidy_select]{tidy-select}}> Columns to unite}

\item{sep}{Separator to use between values.}

\item{remove}{If \code{TRUE}, remove input columns from output data frame.}

\item{na.rm}{If \code{TRUE}, missing values will be removed prior to uniting
each value.}
}
\value{
\code{tidySummarizedExperiment}
}
\description{
Convenience function to paste together multiple columns into one.
}
\examples{
tidySummarizedExperiment::pasilla |>
    unite("group", c(condition, type))
    
}
\references{
Hutchison, W.J., Keyes, T.J., The tidyomics Consortium. et al. The tidyomics ecosystem: enhancing omic data analyses. Nat Methods 21, 1166–1170 (2024). https://doi.org/10.1038/s41592-024-02299-2

Wickham, H., Vaughan, D. (2023). tidyr: Tidy Messy Data. R package version 2.0.0, https://CRAN.R-project.org/package=tidyr
}
\seealso{
\code{\link[tidyr:separate]{separate()}}, the complement.
}
