% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spicy.R
\name{colTest}
\alias{colTest}
\title{Perform a simple wilcoxon-rank-sum test or t-test on the columns of a data
frame}
\usage{
colTest(df, condition, type = NULL, feature = NULL, imageID = "imageID")
}
\arguments{
\item{df}{A data.frame or SingleCellExperiment, SpatialExperiment}

\item{condition}{The condition of interest}

\item{type}{The type of test, "wilcox", "ttest" or "survival".}

\item{feature}{Can be used to calculate the proportions of this feature for each image}

\item{imageID}{The imageID's if presenting a SingleCellExperiment}
}
\value{
Proportions
}
\description{
Perform a simple wilcoxon-rank-sum test or t-test on the columns of a data
frame
}
\examples{

# Test for an association with long-duration diabetes
# This is clearly ignoring the repeated measures...
data("diabetesData")
diabetesData <- spicyR:::.format_data(
  diabetesData, "imageID", "cellType", c("x", "y"), FALSE
)
props <- getProp(diabetesData)
condition <- spicyR:::getImagePheno(diabetesData)$stage
names(condition) <- spicyR:::getImagePheno(diabetesData)$imageID
condition <- condition[condition \%in\% c("Long-duration", "Onset")]
test <- colTest(props[names(condition), ], condition)
}
