% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcMetric.R
\name{calcCrossMetricPerFov}
\alias{calcCrossMetricPerFov}
\title{Calculate cross spatial metrics for all combinations per FOV}
\usage{
calcCrossMetricPerFov(
  spe,
  selection,
  subsetby = NULL,
  fun,
  marks = NULL,
  rSeq = NULL,
  by = NULL,
  ncores = 1,
  continuous = FALSE,
  assay = "exprs",
  ...
)
}
\arguments{
\item{spe}{a \code{SpatialExperiment} object}

\item{selection}{the mark(s) you want to compare}

\item{subsetby}{the spe \code{colData} variable to subset the data by}

\item{fun}{the \code{spatstat} function to compute on the point pattern object}

\item{marks}{the marks to consider e.g. cell types}

\item{rSeq}{the range of r values to compute the function over}

\item{by}{the spe \code{colData} variable(s) to add to the meta data}

\item{ncores}{the number of cores to use for parallel processing, default = 1}

\item{continuous}{A boolean indicating whether the marks are continuous
defaults to FALSE}

\item{assay}{the assay which is used if \code{continuous = TRUE}}

\item{...}{Other parameters passed to spatstat.explore functions}
}
\value{
a dataframe of the \code{spatstat} metric objects with the radius r, the
theoretical value of a Poisson process, the different border corrections
the fov number, the number of points and the centroid of the image
}
\description{
A function that takes a \code{SpatialExperiment} object as input and calculates a
cross spatial metric as implemented by \code{spatstat} per field of view for all
combinations provided by the user.
}
\examples{
# retrieve example data from Damond et al. (2019)
spe <- .loadExample()
metricRes <- calcCrossMetricPerFov(spe, c("alpha", "Tc"),
    subsetby = "image_number", fun = "Gcross", marks = "cell_type",
    rSeq = seq(0, 50, length.out = 50), by = c(
        "patient_stage", "patient_id",
        "image_number"
    ),
    ncores = 1
)

}
