% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadBalanceBplapply.R
\name{loadBalanceBplapply}
\alias{loadBalanceBplapply}
\title{Parallel processing with BiocParallel with load balancing}
\usage{
loadBalanceBplapply(
  iterator,
  func,
  loopFun = if (bpparam()$workers == 1) "lapply" else "bplapply"
)
}
\arguments{
\item{iterator}{The vector to iterate over}

\item{func}{The function to apply to each element}

\item{loopFun}{The looping function, can also be 'lapply' for serial processing}
}
\value{
A list with the same length as iterator
}
\description{
The vector to iterate over (iterator) is split into as many parts as there are
cores available, such that each core gets an equal load and overhead is minimized. 
The registered backend is then used by default to multithread using \link[BiocParallel]{bplapply}.
}
\examples{
library(BiocParallel)
loadBalanceBplapply(LETTERS, length)
}
