% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SlalomModel-methods.R
\name{addResultsToSingleCellExperiment}
\alias{addResultsToSingleCellExperiment}
\title{Add results to SingleCellExperiment object}
\usage{
addResultsToSingleCellExperiment(sce_object, slalom_object, n_active = 20,
  mad_filter = 0.4, annotated = TRUE, unannotated_dense = FALSE,
  unannotated_sparse = FALSE, add_loadings = TRUE, dimred = "slalom",
  check_convergence = TRUE)
}
\arguments{
\item{sce_object}{an object of class
\code{\link[SingleCellExperiment]{SingleCellExperiment}}}

\item{slalom_object}{an object of class \code{Rcpp_SlalomModel}}

\item{n_active}{number of terms (factors) to be added (default is 20)}

\item{mad_filter}{numeric(1), filter factors by this mean absolute deviation
to ensure variability in the factor states. For large datasets this can be
set to 0}

\item{annotated}{logical(1), should annotated factors be included? Default is
\code{TRUE}}

\item{unannotated_dense}{logical(1), should dense unannotated factors be
included? Default is \code{FALSE}}

\item{unannotated_sparse}{logical(1), should sparse unannotated factors be
included? Default is \code{FALSE}}

\item{add_loadings}{logical(1), should gene/feature loadings be added to
the \code{rowData} of the object?}

\item{dimred}{character(1), name of the reduced-dimension slot to save the
factor states to. Default is \code{"slalom"}}

\item{check_convergence}{logical(1), check that model has converged before
adding \code{slalom} results. If \code{TRUE} and model has not converged it
throws an error.}
}
\value{
a \code{\link[SingleCellExperiment]{SingleCellExperiment}} object
with factor states (X) in a reduced-dimension slot, and gene loadings for
factors added to \code{rowData}.
}
\description{
Add results to SingleCellExperiment object
}
\examples{
gmtfile <- system.file("extdata", "reactome_subset.gmt", package = "slalom")
genesets <- GSEABase::getGmt(gmtfile)
data("mesc")
model <- newSlalomModel(mesc, genesets, n_hidden = 5, min_genes = 10)
model <- initSlalom(model)
model <- trainSlalom(model, nIterations = 10)
mesc <- addResultsToSingleCellExperiment(mesc, model,
check_convergence = FALSE)
}
