% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/app.R
\name{scRNAseqApp}
\alias{scRNAseqApp}
\title{scRNAseqApp main function}
\usage{
scRNAseqApp(
  app_path = getwd(),
  datafolder = "data",
  defaultDataset = "pbmc_small",
  windowTitle = "scRNAseq/scATACseq database",
  favicon = system.file("assets", "img", "favicon.ico", package = "scRNAseqApp"),
  banner = system.file("assets", "img", "banner.png", package = "scRNAseqApp"),
  footer = tagList(HTML("&copy;"), "2024 -", format(Sys.Date(), "\%Y"),
    "jianhong@morgridge"),
  maxRequestSize = 1073741824,
  timeout = 30,
  theme = bs_theme(bootswatch = "lumen"),
  use_bs_themer = FALSE,
  showHelpVideo = FALSE,
  ...
)
}
\arguments{
\item{app_path}{path, a directory where do you want to create the app}

\item{datafolder}{the folder where saved the dataset for the app}

\item{defaultDataset}{default dataset for the app.}

\item{windowTitle}{The title that should be displayed by the browser window.}

\item{favicon}{The favicon for the page.}

\item{banner}{The banner image.}

\item{footer}{The footer html contents.}

\item{maxRequestSize}{Maximal upload file size. Default is 1G.}

\item{timeout}{Timeout session (minutes) before logout if sleeping.
Default to 30. 0 to disable.}

\item{theme}{A theme.}

\item{use_bs_themer}{logical(1). Used to determine the theme.}

\item{showHelpVideo}{logical(1) or character(1).
Show help videos in homepage or not. If an url is provided, the
url will be embedded as a iframe element.}

\item{...}{parameters can be passed to shinyApp except ui and server.}
}
\value{
An object that represents the app.
}
\description{
create a scRNAseqApp once the initialization is done.
}
\examples{
if(interactive()){
    app_path=tempdir()
    scInit(app_path=app_path)
    setwd(app_path)
    scRNAseqApp()
}
}
