% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classify_edges.R
\name{classify_edges}
\alias{classify_edges}
\title{Classify Edges as TP, FP, or FN}
\usage{
classify_edges(consensus_matrix, reference_matrix = NULL, use_stringdb = TRUE)
}
\arguments{
\item{consensus_matrix}{A \linkS4class{SummarizedExperiment} object
representing the consensus network.}

\item{reference_matrix}{A \linkS4class{SummarizedExperiment} object
representing the reference (ground truth) network. If \code{NULL},
STRINGdb is used to generate a high-confidence physical network.}

\item{use_stringdb}{Logical. If TRUE and \code{reference_matrix} is NULL,
queries STRINGdb for reference network. Default: TRUE.}
}
\value{
A list containing:
\itemize{
\item \code{tp_edges}: Character vector of True Positive edges
\item \code{fp_edges}: Character vector of False Positive edges
\item \code{fn_edges}: Character vector of False Negative edges
\item \code{consensus_graph}: igraph object of consensus network
\item \code{reference_graph}: igraph object of reference network
\item \code{edge_colors}: Color vector for TP (red) and FN (blue) edges
\item \code{use_stringdb}: Logical indicating if STRINGdb was used
}
}
\description{
Compares a consensus network to a reference network and classifies
edges as True Positives (TP), False Positives (FP), or False
Negatives (FN).
}
\details{
If \code{reference_matrix} is NULL and \code{use_stringdb = TRUE},
this function queries STRINGdb to generate a human high-confidence
(score > 900) physical interaction network.
}
\examples{
data(toy_counts)
data(toy_adj_matrix)


# Infer networks (toy_counts is already a MultiAssayExperiment)
networks <- infer_networks(
    count_matrices_list = toy_counts,
    method = "GENIE3",
    nCores = 1
)

# Generate and symmetrize adjacency matrices (returns SummarizedExperiment)
wadj_se <- generate_adjacency(networks)
swadj_se <- symmetrize(wadj_se, weight_function = "mean")

# Apply cutoff (returns SummarizedExperiment)
binary_se <- cutoff_adjacency(
    count_matrices = toy_counts,
    weighted_adjm_list = swadj_se,
    n = 1,
    method = "GENIE3",
    quantile_threshold = 0.95,
    nCores = 1
)

# Create consensus (returns SummarizedExperiment)
consensus <- create_consensus(binary_se, method = "union")

# Wrap reference matrix in SummarizedExperiment
ref_se <- build_network_se(list(reference = toy_adj_matrix))

# classify_edges expects SummarizedExperiment objects
edge_class <- classify_edges(consensus, ref_se)
}
