/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator.model;

import java.util.ArrayList;
import java.util.HashMap;
import org.jfree.util.Log;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MultiplexMappingInfo;

public class MappingModel {
    private HashMap mappingInfos = new HashMap();
    private ArrayList manualMappings = new ArrayList();
    private ArrayList multiplexMappings = new ArrayList();

    public MultiplexMappingInfo[] getMultiplexMapping() {
        return this.multiplexMappings.toArray(new MultiplexMappingInfo[this.multiplexMappings.size()]);
    }

    public ManualMappingInfo[] getManualMapping() {
        return this.manualMappings.toArray(new ManualMappingInfo[this.manualMappings.size()]);
    }

    public void addManualMapping(ManualMappingInfo mappingInfo) {
        if (!this.mappingInfos.containsKey(mappingInfo.getBaseClass())) {
            this.manualMappings.add(mappingInfo);
            this.mappingInfos.put(mappingInfo.getBaseClass(), mappingInfo);
        } else {
            Object o = this.mappingInfos.get(mappingInfo.getBaseClass());
            if (o instanceof ManualMappingInfo) {
                Log.info("Duplicate manual mapping: " + mappingInfo.getBaseClass());
            } else {
                throw new IllegalArgumentException("This mapping is already a multiplex mapping.");
            }
        }
    }

    public void addMultiplexMapping(MultiplexMappingInfo mappingInfo) {
        if (!this.mappingInfos.containsKey(mappingInfo.getBaseClass())) {
            this.multiplexMappings.add(mappingInfo);
            this.mappingInfos.put(mappingInfo.getBaseClass(), mappingInfo);
        } else {
            Object o = this.mappingInfos.get(mappingInfo.getBaseClass());
            if (o instanceof ManualMappingInfo) {
                throw new IllegalArgumentException("This mapping is already a manual mapping.");
            }
            Log.info("Duplicate Multiplex mapping: " + mappingInfo.getBaseClass(), new Exception());
        }
    }

    public MultiplexMappingInfo lookupMultiplexMapping(Class baseClass) {
        Object o = this.mappingInfos.get(baseClass);
        if (o instanceof MultiplexMappingInfo) {
            return (MultiplexMappingInfo)o;
        }
        return null;
    }
}

