% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial.R
\name{getFuzzyLabel}
\alias{getFuzzyLabel}
\title{Get fuzzy representation of labels}
\usage{
getFuzzyLabel(labels, location, k = 6, alpha = 0.5, ...)
}
\arguments{
\item{labels}{An anomic vector of cluster labels}

\item{location}{A matrix or data.frame of coordinates}

\item{k}{The wished number of nearest neighbors}

\item{alpha}{The parameter to control to what extend the spot itself
contribute to the class composition calculation. \code{"equal"} means it is
weighted the same as other neighbors. A numeric value between \code{0} and \code{1}
means the weight of the frequency contribution for the spot itself, and the
frequency contribution for its knn is then \code{1-alpha}. By default \code{0.5}.}

\item{...}{Passed to \code{\link[=findSpatialKNN]{findSpatialKNN()}}.}
}
\value{
A matrix of fuzzy memberships.
}
\description{
Get fuzzy representation of labels according to the spatial
neighborhood label composition.
}
\examples{
data(sp_toys)
data <- sp_toys
getFuzzyLabel(data$label, data[,c("x", "y")], k=6)
}
