% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-mutate.R
\name{mutate}
\alias{mutate}
\alias{mutate.PlySummarizedExperiment}
\title{Mutate a PlySummarizedExperiment object}
\usage{
\method{mutate}{PlySummarizedExperiment}(.data, ...)
}
\arguments{
\item{.data}{An object Inheriting from \code{PlySummarizedExperiment}, the wrapper
class for \code{SummarizedExperiment} objects}

\item{...}{expressions to evaluate}
}
\value{
an object inheriting PlySummarizedExperiment class
}
\description{
Mutate a PlySummarizedExperiment object under an data mask. Unlike a few other
\code{dplyr} implementations, all contextual evaluations of \code{mutate()} for
\code{SummarizedExperiment} are valid.
}
\examples{

mutate(se_simple,
  counts_1 = counts + 1,
  logp_counts = log(counts_1),
  # access assays context with ".assays" pronoun,
  # note that assays are sliced into a list to
  # fit dimensions of cols context
  cols(sum = purrr::map_dbl(.assays$counts, sum)),
  # access assays context "asis" with the same pronoun
  # but with a "_asis" suffix.
  rows(sum = rowSums(.assays_asis$counts))
)
}
