% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakPantheR_ROIStatistics.R
\name{peakPantheR_ROIStatistics}
\alias{peakPantheR_ROIStatistics}
\title{Save to disk each ROI EIC and mean IS RT}
\usage{
peakPantheR_ROIStatistics(
    referenceSpectraFiles,
    saveFolder,
    ROI = NULL,
    IS_ROI = NULL,
    sampleColour = NULL,
    ncores = 0,
    saveISPlots = TRUE,
    verbose = TRUE
)
}
\arguments{
\item{referenceSpectraFiles}{(str) A character vector of paths to the
reference spectra files}

\item{saveFolder}{(str) Path to the folder where EICs and IS mean RT
(\code{IS_mean_RT.csv}) will be saved}

\item{ROI}{(data.frame) NULL or a data.frame of Regions Of Interest (ROI)
with compounds as row and ROI parameters as columns: \code{rtMin} (float in
seconds), \code{rt} (float in seconds, or \emph{NA}), \code{rtMax} (float in
seconds), \code{mzMin} (float), \code{mz} (float or \emph{NA}), \code{mzMax}
(float) (if NULL, ROI EICs are not saved)}

\item{IS_ROI}{(data.frame) NULL or a data.frame of IS ROI with IS as row and
ROI parameters as columns: \code{rtMin} (float in seconds), \code{rt} (float
in seconds, or \emph{NA}), \code{rtMax} (float in seconds), \code{mzMin}
(float), \code{mz} (float or \emph{NA}), \code{mzMax} (float)  (if NULL IS
mean RT is not calculated and saved in \code{IS_mean_RT.csv})}

\item{sampleColour}{(str) NULL or vector colour for each sample}

\item{ncores}{(int) Number of cores to use to integrate IS in parallel}

\item{saveISPlots}{(bool) If TRUE save a diagnostic plot for each IS to
\code{saveFolder/IS_search} compound}

\item{verbose}{(bool) If TRUE message progress}
}
\value{
None
}
\description{
Using reference samples (\code{referenceSpectraFiles}), save
(to \code{saveFolder}) each ROI EIC (\code{ROI}) and reports the mean apex RT
for all IS (\code{IS_ROI}) across samples
}
\examples{
if(requireNamespace('faahKO')){
## Initialise a peakPantheRAnnotation object with 2 samples and 1 targeted
## compound

# Paths to spectra files
library(faahKO)
spectraPaths <- c(system.file('cdf/KO/ko15.CDF', package = 'faahKO'),
                    system.file('cdf/KO/ko16.CDF', package = 'faahKO'))

# targetFeatTable
targetFeatTable <- data.frame(matrix(vector(), 1, 8, dimnames=list(c(),
                    c('cpdID','cpdName','rtMin','rt','rtMax','mzMin','mz',
                    'mzMax'))), stringsAsFactors=FALSE)
targetFeatTable[1,] <- c('ID-1', 'Cpd 1', 3310., 3344.888, 3390., 522.194778,
                        522.2, 522.205222)
targetFeatTable[,c(3:8)] <- vapply(targetFeatTable[,c(3:8)], as.numeric,
                                    FUN.VALUE=numeric(1))

# input
refSpecFiles  <- spectraPaths
input_ROI     <- targetFeatTable
input_IS_ROI  <- targetFeatTable
sampleColour  <- c('blue', 'red')

# temporary saveFolder
saveFolder1   <- tempdir()

# Calculate ROI statiscs
peakPantheR_ROIStatistics(refSpecFiles, saveFolder1, ROI=input_ROI,
                            IS_ROI=input_IS_ROI, sampleColour=sampleColour,
                            ncores=0, saveISPlots=TRUE, verbose=TRUE)
}
}
