% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning-functions-knntl.R
\name{thetas}
\alias{thetas}
\title{Draw matrix of thetas to test}
\usage{
thetas(nclass, by = 0.5, length.out, verbose = TRUE)
}
\arguments{
\item{nclass}{Number of marker classes}

\item{by}{The increment of the weights. One of \code{1},
\code{0.5}, \code{0.25}, \code{2}, \code{0.1} or \code{0.05}.}

\item{length.out}{The desired length of the weight sequence.}

\item{verbose}{A \code{logical} indicating if the weight sequences
should be printed out. Default is \code{TRUE}.}
}
\value{
A matrix with all possible theta weight combinations.
}
\description{
The possible weights to be considered is a sequence from 0 (favour
auxiliary data) to 1 (favour primary data). Each possible
combination of weights for \code{nclass} classes must be
tested. The \code{thetas} function produces a weight \code{matrix}
for \code{nclass} columns (one for each class) with all possible
weight combinations (number of rows).
}
\examples{
dim(thetas(4, by = 0.5))
dim(thetas(4, by = 0.2))
dim(thetas(5, by = 0.2))
dim(thetas(5, length.out = 5))
dim(thetas(6, by = 0.2))
}
\author{
Lisa Breckels
}
